/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.rest.tools;

import com.sforce.rest.tools.DotNetCodeGenerator;
import com.sforce.rest.tools.PojoCodeGenerator;
import com.sforce.ws.ConnectorConfig;
import com.sforce.ws.tools.ToolsException;

public class CliGen {
    public static void main(String[] args) throws Exception {
        try {
            CliGen.run(args);
        }
        catch (ToolsException e) {
            System.out.println((Object)e);
            System.exit(1);
        }
    }

    static void run(String[] args) throws Exception {
        if (args.length != 4) {
            throw new ToolsException(" usage: java com.sforce.rest.tools.CliGen<java | dotnet> <my.package | my.namespace> <instance> <session ID>");
        }
        String codeGenLanguage = args[0];
        String namespace = args[1];
        String instance = args[2];
        String sid = args[3];
        if (!namespace.contains(".")) {
            throw new ToolsException("Second argument must be a Java package like com.sforce.pojo or C# namespace like Sforce.Sobject");
        }
        if (instance.length() < 3 || instance.contains("salesforce")) {
            throw new ToolsException("Third argument must be an instance like na1, cs0, ap1, na9, eu1");
        }
        if (sid.length() < 24) {
            throw new ToolsException("Fourth argument must be a session ID");
        }
        ConnectorConfig config = new ConnectorConfig();
        config.setRestEndpoint("https://" + instance + ".salesforce.com/services/data/v21.0/");
        config.setSessionId(sid);
        if (codeGenLanguage.equals("java")) {
            PojoCodeGenerator codeGen = new PojoCodeGenerator();
            codeGen.describeMyOrg(config, namespace);
        } else if (codeGenLanguage.equals("dotnet")) {
            DotNetCodeGenerator codeGen = new DotNetCodeGenerator();
            codeGen.describeMyOrg(config, namespace);
        } else {
            throw new ToolsException("Must choose java or dotnet for first argument.");
        }
    }
}

