/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce;

import com.sforce.soap.partner.GetUpdatedResult;
import java.io.Serializable;
import java.util.Calendar;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;

public class ObjectStoreHelper {
    private static final String LATEST_UPDATE_TIME_KEY = "latestUpdateTime";
    private static final String LATEST_UPDATE_TIME_BACKUP_KEY = "latestUpdateTimeBackup";
    private ObjectStore objectStore;
    private String keyPrefix;

    public ObjectStoreHelper(String keyPrefix, ObjectStore objectStore) {
        this.keyPrefix = keyPrefix + '-';
        this.objectStore = objectStore;
    }

    public void updateTimestamp(GetUpdatedResult getUpdatedResult, String type) throws ObjectStoreException {
        if (this.objectStore.contains((Serializable)((Object)this.getLastUpdateTimeKey(type)))) {
            if (this.objectStore.contains((Serializable)((Object)this.getLatestUpdateTimeBackupKey(type)))) {
                this.objectStore.remove((Serializable)((Object)this.getLatestUpdateTimeBackupKey(type)));
            }
            this.objectStore.store((Serializable)((Object)this.getLatestUpdateTimeBackupKey(type)), this.objectStore.retrieve((Serializable)((Object)this.getLastUpdateTimeKey(type))));
            this.objectStore.remove((Serializable)((Object)this.getLastUpdateTimeKey(type)));
        }
        this.objectStore.store((Serializable)((Object)this.getLastUpdateTimeKey(type)), (Serializable)getUpdatedResult.getLatestDateCovered());
    }

    public Calendar getTimestamp(String type) throws ObjectStoreException {
        if (this.objectStore.contains((Serializable)((Object)this.getLastUpdateTimeKey(type)))) {
            return (Calendar)this.objectStore.retrieve((Serializable)((Object)this.getLastUpdateTimeKey(type)));
        }
        if (this.objectStore.contains((Serializable)((Object)this.getLatestUpdateTimeBackupKey(type)))) {
            return (Calendar)this.objectStore.retrieve((Serializable)((Object)this.getLatestUpdateTimeBackupKey(type)));
        }
        return null;
    }

    public void resetTimestamps(String type) throws ObjectStoreException {
        if (this.objectStore.contains((Serializable)((Object)this.getLastUpdateTimeKey(type)))) {
            this.objectStore.remove((Serializable)((Object)this.getLastUpdateTimeKey(type)));
        }
        if (this.objectStore.contains((Serializable)((Object)this.getLatestUpdateTimeBackupKey(type)))) {
            this.objectStore.remove((Serializable)((Object)this.getLatestUpdateTimeBackupKey(type)));
        }
    }

    public String getLastUpdateTimeKey(String type) {
        return this.keyPrefix + '/' + type + '/' + LATEST_UPDATE_TIME_KEY;
    }

    public String getLatestUpdateTimeBackupKey(String type) {
        return this.keyPrefix + '/' + type + '/' + LATEST_UPDATE_TIME_BACKUP_KEY;
    }
}

