/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce;

import com.sforce.soap.partner.PartnerConnection;
import com.sforce.soap.partner.QueryResult;
import com.sforce.soap.partner.sobject.SObject;
import com.sforce.ws.ConnectionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mule.api.MuleException;
import org.mule.modules.salesforce.BaseSalesforceConnector;
import org.mule.modules.salesforce.SalesforceUtils;
import org.mule.modules.salesforce.api.SalesforceHeader;
import org.mule.streaming.ProviderAwarePagingDelegate;

public abstract class SalesforcePagingDelegate
extends ProviderAwarePagingDelegate<Map<String, Object>, BaseSalesforceConnector> {
    private String query;
    private Map<SalesforceHeader, Object> headers;
    private String queryLocator = null;
    private QueryResult cachedQueryResult = null;
    private boolean lastPageFound = false;

    public SalesforcePagingDelegate(String query, Map<SalesforceHeader, Object> headers) {
        this.query = query;
        this.headers = headers;
    }

    public List<Map<String, Object>> getPage(BaseSalesforceConnector connector) throws Exception {
        if (this.cachedQueryResult != null) {
            List<Map<String, Object>> items = this.consume(this.cachedQueryResult);
            this.cachedQueryResult = null;
            return items;
        }
        if (this.lastPageFound) {
            return Collections.emptyList();
        }
        QueryResult queryResult = this.getQueryResult(connector);
        this.setQueryLocatorStatus(queryResult);
        return this.consume(queryResult);
    }

    private void setQueryLocatorStatus(QueryResult queryResult) {
        if (queryResult.isDone()) {
            this.queryLocator = null;
            this.lastPageFound = true;
        } else {
            this.queryLocator = queryResult.getQueryLocator();
        }
    }

    private QueryResult getQueryResult(BaseSalesforceConnector connector) throws Exception {
        return this.queryLocator != null ? connector.getSalesforceSoapAdapter(this.headers).queryMore(this.queryLocator) : this.doQuery(connector.getSalesforceSoapAdapter(this.headers), this.query);
    }

    protected abstract QueryResult doQuery(PartnerConnection var1, String var2) throws ConnectionException;

    private List<Map<String, Object>> consume(QueryResult queryResult) {
        ArrayList<Map<String, Object>> result = null;
        SObject[] records = queryResult.getRecords();
        if (records != null && records.length > 0) {
            result = new ArrayList<Map<String, Object>>();
            for (SObject object : records) {
                result.add(SalesforceUtils.toMap(object));
            }
        }
        return result;
    }

    public void close() throws MuleException {
        this.cachedQueryResult = null;
    }

    public int getTotalResults(BaseSalesforceConnector connector) throws Exception {
        if (this.cachedQueryResult == null) {
            this.cachedQueryResult = this.getQueryResult(connector);
            this.setQueryLocatorStatus(this.cachedQueryResult);
        }
        return this.cachedQueryResult.getSize();
    }
}

