/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.api;

import com.sforce.async.AsyncApiException;
import com.sforce.async.AsyncExceptionCode;
import com.sforce.soap.partner.fault.UnexpectedErrorFault;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.mule.modules.salesforce.exception.SalesforceSessionExpiredException;

public class SalesforceExceptionHandlerAdapter {
    private static Logger logger = Logger.getLogger(SalesforceExceptionHandlerAdapter.class);

    public static Exception analyzeRestException(Exception e) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Analyzing exception " + e.getClass()));
        }
        if (e.getCause() instanceof AsyncApiException && ((AsyncApiException)e.getCause()).getExceptionCode() == AsyncExceptionCode.InvalidSessionId) {
            return new SalesforceSessionExpiredException(e.getCause().getMessage(), e.getCause());
        }
        return e;
    }

    public static Exception analyzeSoapException(Exception e) {
        if (e.getCause() instanceof UnexpectedErrorFault && !StringUtils.isEmpty((String)e.getCause().getMessage()) && e.getCause().getMessage().contains("INVALID_SESSION_ID") || e.getCause().toString() != null && e.getCause().toString().contains("INVALID_SESSION_ID")) {
            return new SalesforceSessionExpiredException(e.getCause());
        }
        return new RuntimeException(e.getCause());
    }
}

