/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.api;

import com.sforce.async.BulkConnection;
import java.lang.reflect.Method;
import java.util.Arrays;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.InvocationHandler;
import org.apache.log4j.Logger;
import org.mule.modules.salesforce.api.SalesforceExceptionHandlerAdapter;

public class SalesforceRestAdapter {
    private static Logger logger = Logger.getLogger(SalesforceRestAdapter.class);

    public static BulkConnection adapt(final BulkConnection facade) {
        return (BulkConnection)Enhancer.create(BulkConnection.class, (Callback)new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Invoked method %s with arguments %s", method.getName(), Arrays.toString(args)));
                }
                try {
                    Object ret = method.invoke((Object)facade, args);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)String.format("Returned method %s with value %s", ret, Arrays.toString(args)));
                    }
                    return ret;
                }
                catch (Exception e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Method " + method.getName() + " threw " + e.getClass()));
                    }
                    throw SalesforceExceptionHandlerAdapter.analyzeRestException(e);
                }
            }
        });
    }
}

