/*
 * Decompiled with CFR 0.152.
 */
package org.mule.configuration;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.mule.configuration.parser.FragmentsConfigurationParser;

public class Configuration {
    private static final String DEFAULT_CONFIGURATION_FILE_NAME = "." + File.separator + "fragments" + File.separator + "fragments.xml";
    private final Map<String, Map<String, String>> fragments = new HashMap<String, Map<String, String>>();
    private FragmentsConfigurationParser defaultFragmentsConfigurationParser;

    public Configuration() {
        this(DEFAULT_CONFIGURATION_FILE_NAME);
    }

    public Configuration(String defaultConfigurationFileName) {
        try {
            this.defaultFragmentsConfigurationParser = new FragmentsConfigurationParser(defaultConfigurationFileName);
        }
        catch (Exception e) {
            throw new RuntimeException("There has been an error parsing the configuration file: " + e.getMessage());
        }
        this.initialise();
    }

    public Map<String, Map<String, String>> getFragments() {
        return this.fragments;
    }

    private void initialise() {
        this.populateFragments();
    }

    private void populateFragments() {
        for (String key : this.defaultFragmentsConfigurationParser.getFragments().keySet()) {
            this.fragments.put(key, this.defaultFragmentsConfigurationParser.getFragments().get(key));
        }
    }
}

