/*
 * Decompiled with CFR 0.152.
 */
package org.mule.configuration.parser;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FragmentsConfigurationParser {
    private static final String SECTIONS_XPATH = "//ns:configuration/ns:fragments/ns:fragment";
    private final Map<String, Map<String, String>> fragments = new HashMap<String, Map<String, String>>();
    private XPath configurationXpath;
    private Document configurationDoc;

    public FragmentsConfigurationParser(String configurationFilePath) throws Exception {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)configurationFilePath), (Object)"The file path can not be null nor empty.");
        this.configurationDoc = this.buildDocument(this.loadFile(configurationFilePath));
        this.configurationXpath = XPathFactory.newInstance().newXPath();
        this.configurationXpath.setNamespaceContext(new FragmentsNamespaceContext());
        this.parse();
    }

    public Map<String, Map<String, String>> getFragments() {
        return this.fragments;
    }

    public String getFragments(String id) {
        String value = this.fragments.get(id).get("code");
        if (value != null) {
            return value;
        }
        throw new RuntimeException("The fragment id: " + id + " is not defined in the configuration file");
    }

    private Document buildDocument(String xml) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(new ByteArrayInputStream(xml.getBytes()));
        return doc;
    }

    private void parse() throws Exception {
        this.parseFragments(this.configurationDoc, this.configurationXpath);
    }

    private void parseFragments(Document doc, XPath xpath) throws Exception {
        NodeList nodeList = (NodeList)xpath.compile(SECTIONS_XPATH).evaluate(doc, XPathConstants.NODESET);
        this.putInMap(this.fragments, nodeList);
    }

    private void putInMap(Map<String, Map<String, String>> destinationMap, NodeList nodeList) throws Exception {
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Node node = nodeList.item(index);
            String key = node.getAttributes().getNamedItem("id").getTextContent();
            HashMap<String, String> value = new HashMap<String, String>();
            value.put("code", node.getTextContent());
            for (int i = 0; i < node.getAttributes().getLength(); ++i) {
                value.put(node.getAttributes().item(i).getLocalName(), node.getAttributes().item(i).getTextContent());
            }
            destinationMap.put(key, value);
        }
    }

    private String loadFile(String filePath) throws IOException {
        InputStream in;
        block2: {
            try {
                in = new FileInputStream(filePath);
            }
            catch (FileNotFoundException e) {
                in = Thread.currentThread().getContextClassLoader().getResourceAsStream(filePath);
                if (in != null) break block2;
                throw new FileNotFoundException("The file " + filePath + " could not be loaded.");
            }
        }
        return IOUtils.toString((InputStream)in);
    }

    private static class FragmentsNamespaceContext
    implements NamespaceContext {
        private FragmentsNamespaceContext() {
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if ("ns".equals(prefix)) {
                return "http://www.mulesoft.com/templates/tooling/fragments";
            }
            return null;
        }

        @Override
        public String getPrefix(String namespaceURI) {
            return null;
        }

        public Iterator getPrefixes(String namespaceURI) {
            return null;
        }
    }
}

