/*
 * Decompiled with CFR 0.152.
 */
package org.mule.core;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.mule.configuration.Configuration;

public class Engine {
    private static final Logger log = Logger.getLogger(Engine.class);
    private static final String FRAGMENT_BEGIN_DELIMITER = "<!--begin-fragment-";
    private static final String FRAGMENT_END_DELIMITER = "<!--end-fragment-";
    private static final String FRAGMENT_DELIMITER_CLOSE = "-->";
    private VelocityEngine ve = new VelocityEngine();
    private Configuration config;
    private boolean fragmentDelimitersEnabled;

    public Engine(boolean fragmentDelimitersEnabled) {
        this.ve.setProperty("resource.loader", (Object)"file");
        this.ve.setProperty("file.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.FileResourceLoader");
        this.ve.setProperty("runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.NullLogSystem");
        this.ve.init();
        log.debug((Object)("Creating Engine: fragmentDelimitersEnabled = " + fragmentDelimitersEnabled));
        this.setFragmentDelimitersEnabled(fragmentDelimitersEnabled);
        this.config = new Configuration();
    }

    public Engine() {
        this(true);
    }

    public String buildContent(String filePath) throws IOException {
        return this.buildOutputXML(filePath);
    }

    private String buildOutputXML(String templateFilePath) throws IOException {
        VelocityContext context = new VelocityContext();
        for (String key : this.config.getFragments().keySet()) {
            context.put(key, (Object)this.createFinalFragmentForKey(key));
        }
        Template template = this.ve.getTemplate(templateFilePath);
        StringWriter writer = new StringWriter();
        template.merge((Context)context, (Writer)writer);
        return writer.toString();
    }

    private String createFinalFragmentForKey(String key) {
        String initialFragment = this.config.getFragments().get(key).get("code");
        if (this.fragmentDelimitersEnabled) {
            return FRAGMENT_BEGIN_DELIMITER + key + FRAGMENT_DELIMITER_CLOSE + initialFragment + FRAGMENT_END_DELIMITER + key + FRAGMENT_DELIMITER_CLOSE;
        }
        return initialFragment;
    }

    public String cleanFragmentDelimiters(String templateContent) {
        return templateContent.replaceAll("(<!--begin-fragment-|<!--end-fragment-).+-->", "");
    }

    public boolean getFragmentDelimitersEnabled() {
        return this.fragmentDelimitersEnabled;
    }

    public void setFragmentDelimitersEnabled(boolean fragmentDelimitersEnabled) {
        this.fragmentDelimitersEnabled = fragmentDelimitersEnabled;
    }
}

