/*
 * Decompiled with CFR 0.152.
 */
package org.mule.plugin.mojo;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.mule.core.Engine;
import org.mule.writer.TemplateWriter;

public class ApplyFragmentsMojo
extends AbstractMojo {
    private static final String CONFIG_FILES_PATH = "." + File.separator + "src" + File.separator + "main" + File.separator + "app" + File.separator;
    private static final String CONFIG_FILES_EXTENSION = ".xml";
    private static final String TEMPLATES_PATH = "." + File.separator + "templates" + File.separator;
    private static final String TEMPLATES_EXTENSION = ".template";
    private Engine engine;
    private boolean skipFragmentDelimiters;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"About to build final template...");
        this.getLog().info((CharSequence)("skipFragmentDelimiters=" + this.skipFragmentDelimiters));
        this.engine = new Engine(!this.skipFragmentDelimiters);
        File dir = new File(CONFIG_FILES_PATH);
        File[] listOfFiles = dir.listFiles();
        for (int i = 0; i < listOfFiles.length; ++i) {
            if (!listOfFiles[i].isFile() || !listOfFiles[i].getName().endsWith(CONFIG_FILES_EXTENSION)) continue;
            this.applyFragmentToXML(listOfFiles[i].toString().replace(CONFIG_FILES_PATH, TEMPLATES_PATH).replace(CONFIG_FILES_EXTENSION, TEMPLATES_EXTENSION), listOfFiles[i].toString());
        }
        this.getLog().info((CharSequence)"Template has been generated");
    }

    private void applyFragmentToXML(String templateFilePath, String xmlFilePath) {
        try {
            String templateContent = this.engine.buildContent(templateFilePath);
            this.getLog().info((CharSequence)("Applying template " + templateFilePath + " on XML " + xmlFilePath));
            TemplateWriter.writeContentTo(templateContent, xmlFilePath);
            this.getLog().info((CharSequence)("XML " + xmlFilePath + " has been written"));
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new RuntimeException("There has been an error writing XML " + xmlFilePath, e);
        }
    }

    public Engine getEngine() {
        return this.engine;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public Boolean getSkipFragmentDelimiters() {
        return this.skipFragmentDelimiters;
    }

    public void setSkipFragmentDelimiters(Boolean skipFragmentDelimiters) {
        this.skipFragmentDelimiters = skipFragmentDelimiters;
    }
}

