/*
 * Decompiled with CFR 0.152.
 */
package org.mule.plugin.mojo;

import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.mule.core.Engine;
import org.mule.reader.TemplateReader;
import org.mule.writer.TemplateWriter;

public class CleanFragmentDelimitersMojo
extends AbstractMojo {
    private static final String CONFIG_FILES_PATH = "./src/main/app/";
    private static final String CONFIG_FILES_EXTENSION = ".xml";
    private Engine engine;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"About to clean fragment delimiters from template...");
        this.engine = new Engine();
        File dir = new File(CONFIG_FILES_PATH);
        File[] listOfFiles = dir.listFiles();
        for (int i = 0; i < listOfFiles.length; ++i) {
            if (!listOfFiles[i].isFile() || !listOfFiles[i].getName().endsWith(CONFIG_FILES_EXTENSION)) continue;
            this.cleanFragmentFromXML(listOfFiles[i].toString());
        }
    }

    private void cleanFragmentFromXML(String xmlFilePath) {
        try {
            String templateContent = TemplateReader.readContentFrom(xmlFilePath);
            if (StringUtils.isNotBlank((String)templateContent)) {
                this.getLog().info((CharSequence)("Cleaning fragments on XML " + xmlFilePath));
                TemplateWriter.writeContentTo(this.engine.cleanFragmentDelimiters(templateContent), xmlFilePath);
                this.getLog().info((CharSequence)("Fragments cleaned for XML " + xmlFilePath));
            } else {
                this.getLog().info((CharSequence)("XML " + xmlFilePath + " was not found"));
            }
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new RuntimeException("There has been an error writing cleaning " + xmlFilePath, e);
        }
    }

    public Engine getEngine() {
        return this.engine;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }
}

