/*
 * Decompiled with CFR 0.152.
 */
package org.mule.plugin.mojo;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class InitTemplatesMojo
extends AbstractMojo {
    private static final String CONFIG_FILES_PATH = "." + File.separator + "src" + File.separator + "main" + File.separator + "app" + File.separator;
    private static final String CONFIG_FILES_EXTENSION = ".xml";
    private static final String TEMPLATES_PATH = "." + File.separator + "templates" + File.separator;
    private static final String TEMPLATES_EXTENSION = ".template";

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"About to initialize missing templates...");
        File dir = new File(CONFIG_FILES_PATH);
        File[] listOfFiles = dir.listFiles();
        this.createTemplatesFolder(new File(TEMPLATES_PATH));
        for (int i = 0; i < listOfFiles.length; ++i) {
            if (!listOfFiles[i].isFile() || !listOfFiles[i].getName().endsWith(CONFIG_FILES_EXTENSION)) continue;
            this.initTemplate(listOfFiles[i].toString().replace(CONFIG_FILES_PATH, TEMPLATES_PATH).replace(CONFIG_FILES_EXTENSION, TEMPLATES_EXTENSION), listOfFiles[i].toString());
        }
        this.getLog().info((CharSequence)"Templates have been initialized");
    }

    private void createTemplatesFolder(File templatesPath) {
        try {
            FileUtils.forceMkdir((File)templatesPath);
        }
        catch (IOException e) {
            throw new RuntimeException("There has been an error writing templates folder ", e);
        }
    }

    private void initTemplate(String templateFilePath, String xmlFilePath) {
        try {
            this.getLog().info((CharSequence)("Initializing template " + templateFilePath + " from XML " + xmlFilePath));
            Files.copy(Paths.get(xmlFilePath, new String[0]), Paths.get(templateFilePath, new String[0]), StandardCopyOption.COPY_ATTRIBUTES);
            this.getLog().info((CharSequence)("Template " + templateFilePath + " has been written"));
        }
        catch (FileAlreadyExistsException e) {
            this.getLog().info((CharSequence)("Template " + templateFilePath + " already exists. Skipping..."));
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
            throw new RuntimeException("There has been an error writing template " + templateFilePath, e);
        }
    }
}

