/*
 * Decompiled with CFR 0.152.
 */
package org.mule.core;

import org.apache.commons.lang.StringUtils;
import org.mule.configuration.Section;
import org.mule.configuration.pom.TemplatePomReader;

public class SectionSelector {
    private static final String DB_SYSTEM_ID = "db";
    private static final String SAP_SYSTEM_ID = "sap";
    private static final String SFDC_SYSTEM_ID = "sfdc";
    private static final String SIEB_SYSTEM_ID = "sieb";
    private static final String SNOW_SYSTEM_ID = "snow";
    private static final String WDAY_SYSTEM_ID = "wday";
    private TemplatePomReader pomReader;

    public SectionSelector() {
        this(new TemplatePomReader());
    }

    public SectionSelector(TemplatePomReader pomReader) {
        this.pomReader = pomReader;
    }

    public boolean addSection(String sectionId) {
        Section section = null;
        try {
            section = Section.valueOf(sectionId.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        if (section.evaluateSystems()) {
            String systemId = this.selectSystemToEvaluate(sectionId);
            return StringUtils.isNotBlank((String)systemId) && this.addSystemDependantSection(sectionId, systemId);
        }
        return true;
    }

    private boolean addSystemDependantSection(String sectionId, String systemId) {
        if (sectionId.contains(systemId + "_") && this.isSystemPresentInTemplate(systemId)) {
            if (sectionId.contains("_preconditions")) {
                return true;
            }
            if ("bidirectional".equals(this.pomReader.getPattern())) {
                return true;
            }
            if (sectionId.contains("_src") && this.pomReader.getSourceSystem().equals(systemId)) {
                return true;
            }
            if (sectionId.contains("_dst") && this.pomReader.getDestinationSystem().equals(systemId)) {
                return true;
            }
        }
        return false;
    }

    private String selectSystemToEvaluate(String sectionId) {
        if (sectionId.contains("db_")) {
            return DB_SYSTEM_ID;
        }
        if (sectionId.contains("sap_")) {
            return SAP_SYSTEM_ID;
        }
        if (sectionId.contains("sfdc_")) {
            return SFDC_SYSTEM_ID;
        }
        if (sectionId.contains("sieb_")) {
            return SIEB_SYSTEM_ID;
        }
        if (sectionId.contains("snow_")) {
            return SNOW_SYSTEM_ID;
        }
        if (sectionId.contains("wday_")) {
            return WDAY_SYSTEM_ID;
        }
        return "";
    }

    private boolean isSystemPresentInTemplate(String systemId) {
        return systemId.equals(this.pomReader.getSourceSystem()) || systemId.equals(this.pomReader.getDestinationSystem());
    }
}

