/*
 * Decompiled with CFR 0.152.
 */
package org.mule.configuration.parser;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ConfigurationParser {
    private static final String SECTIONS_XPATH = "//configuration/sections/section";
    private static final String PLACEHOLDERS_XPATH = "//configuration/placeholders/placeholder";
    private XPath configurationXpath;
    private Document configurationDoc;
    private final Map<String, String> sections = new HashMap<String, String>();
    private final Map<String, String> placeholders = new HashMap<String, String>();

    public ConfigurationParser(String configurationFilePath) throws Exception {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)configurationFilePath), (Object)"The file path can not be null nor empty.");
        this.configurationDoc = this.buildDocument(this.loadFile(configurationFilePath));
        this.configurationXpath = XPathFactory.newInstance().newXPath();
        this.parse();
    }

    public Map<String, String> getPlaceHolders() {
        return this.placeholders;
    }

    public String getPlaceholder(String id) {
        String value = this.placeholders.get(id);
        if (value != null) {
            return value;
        }
        throw new RuntimeException("The placeholder id: " + id + " is not defined in the configuration file");
    }

    public Map<String, String> getSections() {
        return this.sections;
    }

    public String getSection(String id) {
        String value = this.sections.get(id);
        if (value != null) {
            return value;
        }
        throw new RuntimeException("The section id: " + id + " is not defined in the configuration file");
    }

    private Document buildDocument(String xml) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(new ByteArrayInputStream(xml.getBytes()));
        return doc;
    }

    private void parse() throws Exception {
        this.parsePlaceholders(this.configurationDoc, this.configurationXpath);
        this.parseSections(this.configurationDoc, this.configurationXpath);
    }

    private void parsePlaceholders(Document doc, XPath xpath) throws Exception {
        NodeList nodeList = (NodeList)xpath.compile(PLACEHOLDERS_XPATH).evaluate(doc, XPathConstants.NODESET);
        this.putInMap(this.placeholders, nodeList);
    }

    private void parseSections(Document doc, XPath xpath) throws Exception {
        NodeList nodeList = (NodeList)xpath.compile(SECTIONS_XPATH).evaluate(doc, XPathConstants.NODESET);
        this.putInMap(this.sections, nodeList);
    }

    private void putInMap(Map<String, String> destinationMap, NodeList nodeList) throws Exception {
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Node node = nodeList.item(index);
            String key = node.getAttributes().getNamedItem("id").getTextContent();
            String value = node.getTextContent();
            value = this.beautifyValue(value);
            destinationMap.put(key, value);
        }
    }

    private String beautifyValue(String value) {
        String niceValue = value;
        String carryRet = System.getProperty("line.separator");
        niceValue = niceValue.trim();
        niceValue = StringUtils.removeStart((String)niceValue, (String)carryRet);
        niceValue = StringUtils.removeEnd((String)niceValue, (String)carryRet);
        return niceValue;
    }

    private String loadFile(String filePath) throws IOException {
        InputStream in;
        block2: {
            try {
                in = new FileInputStream(filePath);
            }
            catch (FileNotFoundException e) {
                in = Thread.currentThread().getContextClassLoader().getResourceAsStream(filePath);
                if (in != null) break block2;
                throw new FileNotFoundException("The file " + filePath + " could not be loaded.");
            }
        }
        return IOUtils.toString((InputStream)in);
    }
}

