/*
 * Decompiled with CFR 0.152.
 */
package org.mule.configuration.pom;

import java.io.FileReader;
import java.io.Reader;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;

public class PomReader {
    private static final String DEFAULT_POM_FILE_PATH = "./pom.xml";
    private Model model;

    public static void main(String[] args) throws Exception {
        new PomReader().getArtifactId();
    }

    public PomReader() {
        this(DEFAULT_POM_FILE_PATH);
    }

    public PomReader(String pomXmlFile) {
        FileReader reader = null;
        try {
            reader = new FileReader(pomXmlFile);
            MavenXpp3Reader xpp3Reader = new MavenXpp3Reader();
            this.model = xpp3Reader.read((Reader)reader);
        }
        catch (Exception e) {
            throw new RuntimeException("There was an error trying to read the pom file.");
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (Exception e) {
                    throw new RuntimeException("There was an error trying to close the pom file.");
                }
            }
        }
    }

    public String getArtifactId() {
        return this.model.getArtifactId();
    }
}

