package org.mule.plugin.mojo;

import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.mule.core.Engine;
import org.mule.writer.ReadMeWriter;

/**
 * The {@link ReadmeGeneratorMojo} allows the user to create a READE.me file in the root folder of
 * the project using the plugin.
 * <p/>
 *
 * @author damiansima
 * @phase package
 * @goal readme
 */
public class ReadmeGeneratorMojo extends AbstractMojo {

    private static final String DEFAULT_FILE_PATH = "./README.md";

    /**
     * Define if the plugin should be executed
     *
     * @parameter expression=${skip.readme.generation}
     */
    private Boolean skipGeneration;

    private String readmeFilePath;

    private Engine engine;

    public ReadmeGeneratorMojo() {
        super();
    }

    public void setReadmeFilePath(String readmeFilePath) {
        this.readmeFilePath = readmeFilePath;
    }

    public String getReadmeFilePath() {
        if (StringUtils.isBlank(readmeFilePath)) {
            return DEFAULT_FILE_PATH;
        }

        return readmeFilePath;
    }

    public Engine getEngine() {
    	if (engine == null) {
    		engine = new Engine();
    	}
    	
        return engine;
    }

    public void execute() throws MojoExecutionException {
        getLog().info("About to build README.md...");

        if (skipGeneration == true) {
            getLog().info("Plugin execution has been skipped, README.md will not be generated...");
            return;
        }

        try {
        	Engine engine = getEngine();
        	
            String readmeContent = engine.buildReadme();

            getLog().info("Writing README.md file...");
            ReadMeWriter.writeContentTo(readmeContent, getReadmeFilePath());

            getLog().info("README.md has been written");
        } catch (Exception e) {
            getLog().error(e);
            throw new RuntimeException("There has been an error when generating the README.md", e);
        }

        getLog().info("README.md has been generated");
    }

    public Boolean getSkipGeneration() {
        return skipGeneration;
    }

    public void setSkipGeneration(Boolean skipGeneration) {
        this.skipGeneration = skipGeneration;
    }
}
