package org.mule.configuration.pom;

import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;

import java.io.FileReader;
import java.io.Reader;

/**
 * Created by damiansima on 6/23/14.
 */
public class PomReader {
    private static final String DEFAULT_POM_FILE_PATH = "./pom.xml";

    private Model model;

    public static void main(String[] args) throws Exception {

        new PomReader().getArtifactId();
    }

    public PomReader() {
        this(DEFAULT_POM_FILE_PATH);
    }

    public PomReader(String pomXmlFile) {
        Reader reader = null;
        try {
            reader = new FileReader(pomXmlFile);
            MavenXpp3Reader xpp3Reader = new MavenXpp3Reader();
            this.model = xpp3Reader.read(reader);

        } catch (Exception e) {
            throw new RuntimeException("There was an error trying to read the pom file.");
        } finally {
            if (reader != null) {
                try {
                    reader.close();
                } catch (Exception e) {
                    throw new RuntimeException("There was an error trying to close the pom file.");
                }
            }
        }
    }

    public String getArtifactId() {
        return model.getArtifactId();
    }
}
