package org.mule.configuration.pom;

import org.apache.commons.lang.StringUtils;

/**
 * Created by damiansima on 6/24/14.
 */
public class TemplatePomReader {

    public static final String AGGREGATION_PATTERN = "aggregation";
    public static final String MIGRATION_PATTERN = "migration";
    public static final String BROADCAST_PATTERN = "broadcast";
    public static final String BIDIRECTIONAL_PATTERN = "bidirectional";

    private PomReader pomReader;

    public TemplatePomReader() {
        this.pomReader = new PomReader();
    }

    public PomReader getPomReader() {
        return pomReader;
    }

    public void setPomReader(PomReader pomReader) {
        this.pomReader = pomReader;
    }

    public String getSourceSystem() {
        String[] systems = StringUtils.split(getSystems(), "2");
        return systems[0];
    }

    public String getDestinationSystem() {
        String[] systems = StringUtils.split(getSystems(), "2");
        return systems[1];
    }

    private String getSystems() {
        String[] tokens = StringUtils.split(pomReader.getArtifactId(), "-");
        return tokens[1];
    }

    public String getEntity() {
        String[] tokens = StringUtils.split(pomReader.getArtifactId(), "-");
        return tokens[2];
    }

    public String getPattern() {
        String[] tokens = StringUtils.split(pomReader.getArtifactId(), "-");
        return tokens[3];
    }

}
