/*
 * Decompiled with CFR 0.152.
 */
package org.mule.plugin.mojo;

import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.mule.core.Engine;
import org.mule.writer.ReadMeWriter;

public class ReadmeGeneratorMojo
extends AbstractMojo {
    private static final String DEFAULT_FILE_PATH = "./README.md";
    private Boolean skipGeneration;
    private String readmeFilePath;
    private Engine engine;

    public void setReadmeFilePath(String readmeFilePath) {
        this.readmeFilePath = readmeFilePath;
    }

    public String getReadmeFilePath() {
        if (StringUtils.isBlank((String)this.readmeFilePath)) {
            return DEFAULT_FILE_PATH;
        }
        return this.readmeFilePath;
    }

    public Engine getEngine() {
        if (this.engine == null) {
            this.engine = new Engine();
        }
        return this.engine;
    }

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"About to build README.md...");
        if (this.skipGeneration.booleanValue()) {
            this.getLog().info((CharSequence)"Plugin execution has been skipped, README.md will not be generated...");
            return;
        }
        try {
            Engine engine = this.getEngine();
            String readmeContent = engine.buildReadme();
            this.getLog().info((CharSequence)"Writing README.md file...");
            ReadMeWriter.writeContentTo(readmeContent, this.getReadmeFilePath());
            this.getLog().info((CharSequence)"README.md has been written");
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new RuntimeException("There has been an error when generating the README.md", e);
        }
        this.getLog().info((CharSequence)"README.md has been generated");
    }

    public Boolean getSkipGeneration() {
        return this.skipGeneration;
    }

    public void setSkipGeneration(Boolean skipGeneration) {
        this.skipGeneration = skipGeneration;
    }
}

