/*
 * Decompiled with CFR 0.152.
 */
package org.mule.core;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.mule.configuration.Configuration;
import org.mule.configuration.ConfigurationValidationProvider;
import org.mule.configuration.Placeholder;
import org.mule.configuration.Section;
import org.mule.core.SectionSelector;

public class Engine {
    private static final Logger log = Logger.getLogger(Engine.class);
    private static final String TEMPLATE_FILE_PATH = "README.template";
    private VelocityEngine ve;
    private Configuration config;
    private List<Section> sectionsToValidate;
    private List<Placeholder> placeholdersToValidate;
    private SectionSelector selector = new SectionSelector();

    public Engine() {
        this(ConfigurationValidationProvider.getPlaceholdersToValidate(), ConfigurationValidationProvider.getSectionsToValidate());
    }

    public SectionSelector getSelector() {
        return this.selector;
    }

    public void setSelector(SectionSelector selector) {
        this.selector = selector;
    }

    public Engine(List<Placeholder> placeholderstoValidate, List<Section> sectionsToValidate) {
        Preconditions.checkNotNull(sectionsToValidate, (Object)"The sections to validate should not be null.");
        Preconditions.checkNotNull(placeholderstoValidate, (Object)"The placeholders to validate should not be null.");
        this.sectionsToValidate = sectionsToValidate;
        this.placeholdersToValidate = placeholderstoValidate;
        this.ve = new VelocityEngine();
        this.ve.setProperty("resource.loader", (Object)"class");
        this.ve.setProperty("class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        this.ve.setProperty("runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.NullLogSystem");
        this.ve.init();
        this.config = new Configuration();
    }

    public String buildReadme() throws IOException {
        this.validateSections();
        this.validatePlaceholders();
        return this.buildReadmeWithIndex(this.buildMainReadme());
    }

    private void validatePlaceholders() {
        for (Placeholder ph : this.placeholdersToValidate) {
            if (!ph.mandatory() || this.config.getPlaceholders().get(ph.placeholder()) != null) continue;
            throw new RuntimeException("The placeholder " + ph.placeholder() + " is mandatory but it has not been provided.");
        }
    }

    private void validateSections() {
        for (Section s : this.sectionsToValidate) {
            if (!s.mandatory() || this.config.getSections().get(s.section()) != null) continue;
            throw new RuntimeException("The section " + s.section() + " is mandatory but it has not been provided.");
        }
    }

    private String buildMainReadme() {
        VelocityContext context = new VelocityContext();
        this.putSectionsIntoContext(context);
        this.putPlaceholdersIntoContext(context);
        Template template = this.ve.getTemplate(TEMPLATE_FILE_PATH);
        StringWriter writer = new StringWriter();
        template.merge((Context)context, (Writer)writer);
        return writer.toString();
    }

    private void putPlaceholdersIntoContext(VelocityContext context) {
        for (String key : this.config.getPlaceholders().keySet()) {
            context.put(key, (Object)ConfigurationValidationProvider.validateConfigurationValue(key, this.config.getPlaceholders().get(key)));
        }
    }

    private void putSectionsIntoContext(VelocityContext context) {
        for (String key : this.config.getSections().keySet()) {
            if (!this.selector.addSection(key)) continue;
            context.put(key, (Object)ConfigurationValidationProvider.validateConfigurationValue(key, this.config.getSections().get(key)));
        }
        context.put("system_src", context.get(this.selector.getSourceSection()));
        if (!this.selector.getSourceSection().equals(this.selector.getDestinationSection())) {
            context.put("system_dst", context.get(this.selector.getDestinationSection()));
        }
    }

    private String buildReadmeWithIndex(String readmeContent) {
        String index = this.buildIndex(readmeContent);
        return StringUtils.replace((String)readmeContent, (String)"$index", (String)index);
    }

    private String buildIndex(String readmeContent) {
        Scanner scanner = new Scanner(readmeContent);
        String carryRet = System.getProperty("line.separator");
        scanner.next();
        StringBuilder indexBuilder = new StringBuilder();
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (!line.startsWith("#") || !StringUtils.contains((String)line, (String)"<a name=")) continue;
            String[] tokens = line.split("<a name=");
            String anchorText = tokens[0].replace("#", "");
            anchorText = anchorText.trim();
            String anchorLink = tokens[1].replace("\"", "").replace("/>", "").trim();
            String indexEntry = "[" + anchorText + "](#" + anchorLink + ")";
            if (line.startsWith("##")) {
                indexEntry = "\t* " + indexEntry;
                indexBuilder.append(indexEntry).append(carryRet);
                continue;
            }
            if (!line.startsWith("#")) continue;
            indexEntry = "+ " + indexEntry;
            indexBuilder.append(indexEntry).append(carryRet);
        }
        return indexBuilder.toString();
    }
}

