/*
 * Decompiled with CFR 0.152.
 */
package org.mule.core;

import org.apache.commons.lang.StringUtils;
import org.mule.configuration.Section;
import org.mule.configuration.pom.TemplatePomReader;

public class SectionSelector {
    private static final String DB_SYSTEM_ID = "db";
    private static final String SAP_SYSTEM_ID = "sap";
    private static final String SFDC_SYSTEM_ID = "sfdc";
    private static final String SIEB_SYSTEM_ID = "sieb";
    private static final String SNOW_SYSTEM_ID = "snow";
    private static final String WDAY_SYSTEM_ID = "wday";
    private static final String JOBV_SYSTEM_ID = "jobv";
    private static final String NETS_SYSTEM_ID = "nets";
    private static final String MSDYN_SYSTEM_ID = "msdyn";
    private static final String MSSP_SYSTEM_ID = "mssp";
    private static final String WDAYF_SYSTEM_ID = "wdayf";
    private static final String MKTO_SYSTEM_ID = "mkto";
    private static final String S4HANA_SYSTEM_ID = "s4hana";
    private TemplatePomReader pomReader;

    public SectionSelector() {
        this(new TemplatePomReader());
    }

    public SectionSelector(TemplatePomReader pomReader) {
        this.pomReader = pomReader;
    }

    public boolean addSection(String sectionId) {
        Section section = null;
        try {
            section = Section.valueOf(sectionId.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        if (section.evaluateSystems()) {
            String systemId = this.selectSystemToEvaluate(sectionId);
            return StringUtils.isNotBlank((String)systemId) && this.addSystemDependantSection(sectionId, systemId);
        }
        return true;
    }

    public String getSourceSection() {
        return "default_" + this.pomReader.getSourceSystem() + "_preconditions";
    }

    public String getDestinationSection() {
        return "default_" + this.pomReader.getDestinationSystem() + "_preconditions";
    }

    private boolean addSystemDependantSection(String sectionId, String systemId) {
        if (sectionId.contains(systemId + "_") && this.isSystemPresentInTemplate(systemId)) {
            if (sectionId.contains("_preconditions")) {
                return true;
            }
            if ("bidirectional".equals(this.pomReader.getPattern())) {
                return true;
            }
            if (sectionId.contains("_src") && this.pomReader.getSourceSystem().contains(systemId)) {
                return true;
            }
            if (sectionId.contains("_dst") && this.pomReader.getDestinationSystem().contains(systemId)) {
                return true;
            }
        }
        return false;
    }

    private String selectSystemToEvaluate(String sectionId) {
        if (sectionId.contains("db_")) {
            return DB_SYSTEM_ID;
        }
        if (sectionId.contains("sap_")) {
            return SAP_SYSTEM_ID;
        }
        if (sectionId.contains("sfdc_")) {
            return SFDC_SYSTEM_ID;
        }
        if (sectionId.contains("sieb_")) {
            return SIEB_SYSTEM_ID;
        }
        if (sectionId.contains("snow_")) {
            return SNOW_SYSTEM_ID;
        }
        if (sectionId.contains("wday_")) {
            return WDAY_SYSTEM_ID;
        }
        if (sectionId.contains("jobv_")) {
            return JOBV_SYSTEM_ID;
        }
        if (sectionId.contains("nets_")) {
            return NETS_SYSTEM_ID;
        }
        if (sectionId.contains("msdyn_")) {
            return MSDYN_SYSTEM_ID;
        }
        if (sectionId.contains("mssp_")) {
            return MSSP_SYSTEM_ID;
        }
        if (sectionId.contains("wdayf_")) {
            return WDAYF_SYSTEM_ID;
        }
        if (sectionId.contains("mkto_")) {
            return MKTO_SYSTEM_ID;
        }
        if (sectionId.contains("s4hana_")) {
            return S4HANA_SYSTEM_ID;
        }
        return "";
    }

    private boolean isSystemPresentInTemplate(String systemId) {
        return this.pomReader.getSourceSystem().contains(systemId) || this.pomReader.getDestinationSystem().contains(systemId);
    }
}

