/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.extensions.http.mock.internal.server;

import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.test.extensions.http.mock.internal.server.HTTPMockServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="server")
public class HTTPMockServerConnectionProvider
implements CachedConnectionProvider<HTTPMockServer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HTTPMockServerConnectionProvider.class);
    @Parameter
    private Integer port;

    public HTTPMockServer connect() {
        try {
            return new HTTPMockServer(this.port);
        }
        catch (Exception e) {
            LOGGER.error("Error creating the server", (Throwable)e);
            return null;
        }
    }

    public void disconnect(HTTPMockServer server) {
        try {
            server.invalidate();
        }
        catch (Exception e) {
            LOGGER.error("Error while disconnecting", (Throwable)e);
        }
    }

    public ConnectionValidationResult validate(HTTPMockServer connection) {
        return ConnectionValidationResult.success();
    }
}

