/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.extensions.http.mock.internal.server;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.test.extensions.http.mock.internal.server.HTTPMockRequestAttributes;
import org.mule.test.extensions.http.mock.internal.server.HTTPMockServerResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegateToFlowTransformer {
    public static final String RESPONSE_FUTURE_PARAMETER = "response-future";
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegateToFlowTransformer.class);

    private DelegateToFlowTransformer() {
    }

    public static HTTPMockServerResponse delegate(SourceCallback<InputStream, HTTPMockRequestAttributes> callback, byte[] requestBody) {
        SourceCallbackContext context = callback.createContext();
        CompletableFuture future = new CompletableFuture();
        context.addVariable(RESPONSE_FUTURE_PARAMETER, future);
        callback.handle(Result.builder().output((Object)new ByteArrayInputStream(requestBody)).attributes((Object)new HTTPMockRequestAttributes()).build(), context);
        try {
            return (HTTPMockServerResponse)future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error("Interrupted while waiting for flow to complete", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            LOGGER.error("Exception during flow execution", (Throwable)e);
        }
        HTTPMockServerResponse errorResponse = new HTTPMockServerResponse();
        errorResponse.setStatusCode(500);
        errorResponse.setReasonPhrase("Internal Server Error");
        return errorResponse;
    }
}

