/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.extensions.http.mock.internal.server;

import java.io.InputStream;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.execution.OnSuccess;
import org.mule.runtime.extension.api.annotation.execution.OnTerminate;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.test.extensions.http.mock.internal.server.HTTPMockRequestAttributes;
import org.mule.test.extensions.http.mock.internal.server.HTTPMockServer;
import org.mule.test.extensions.http.mock.internal.server.HTTPMockServerConfiguration;
import org.mule.test.extensions.http.mock.internal.server.HTTPMockServerResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MediaType(value="*/*", strict=false)
@Alias(value="server-endpoint")
public class HTTPMockServerEndpointSource
extends Source<InputStream, HTTPMockRequestAttributes> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HTTPMockServerEndpointSource.class);
    @Config
    private HTTPMockServerConfiguration config;
    @Connection
    private ConnectionProvider<HTTPMockServer> serverProvider;
    @Parameter
    private String path;
    private HTTPMockServer mockServer;
    private HTTPMockServer.StubRemover removeStubCallback;

    public void onStart(SourceCallback<InputStream, HTTPMockRequestAttributes> sourceCallback) throws MuleException {
        this.mockServer = (HTTPMockServer)this.serverProvider.connect();
        this.removeStubCallback = this.mockServer.addHandlerFor(this.path, sourceCallback);
    }

    public void onStop() {
        this.removeStubCallback.removeStub();
        this.serverProvider.disconnect((Object)this.mockServer);
    }

    @OnTerminate
    public void onTerminate() {
        LOGGER.warn("TERMINATE CALLED, BUT NOT IMPLEMENTED");
    }

    @OnSuccess
    public void completeResponse(@ParameterGroup(name="response", showInDsl=true) HTTPMockServerResponse response, SourceCallbackContext callbackContext) {
        LOGGER.info("Completing response from flow...");
        Optional responseFutureOptional = callbackContext.getVariable("response-future");
        ((CompletableFuture)responseFutureOptional.orElseThrow(() -> new IllegalStateException("Source callback context doesn't have the response future"))).complete(response);
    }
}

