/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.extensions.http.mock.internal.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Servlet;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.test.extensions.http.mock.internal.server.DelegateToFlowTransformer;
import org.mule.test.extensions.http.mock.internal.server.HTTPMockRequestAttributes;
import org.mule.test.extensions.http.mock.internal.server.HTTPMockServerResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPMockServer {
    private final Server server;
    private final ConcurrentHashMap<String, SourceCallback<?, ?>> pathToCallback = new ConcurrentHashMap();
    private static final Logger LOGGER = LoggerFactory.getLogger(HTTPMockServer.class);

    public HTTPMockServer(int port) throws Exception {
        this.server = new Server(port);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        context.addServlet(new ServletHolder((Servlet)new MockServlet()), "/*");
        context.addServlet(new ServletHolder((Servlet)new ExpectContinueServlet()), "/expect-continue");
        this.server.setHandler((Handler)context);
        this.server.start();
        LOGGER.info("HTTP mock server started on port {}", (Object)port);
    }

    public void invalidate() {
        try {
            this.server.stop();
            LOGGER.info("HTTP mock server stopped successfully");
        }
        catch (Exception e) {
            LOGGER.error("Failed to stop the HTTP mock server", (Throwable)e);
        }
    }

    public StubRemover addHandlerFor(String path, SourceCallback<?, ?> callback) {
        this.pathToCallback.put(path, callback);
        LOGGER.info("Registered handler for path: {}", (Object)path);
        return new StubRemover(path);
    }

    private class ExpectContinueServlet
    extends HttpServlet {
        private ExpectContinueServlet() {
        }

        protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
            this.handle(req, resp);
        }

        private void handle(HttpServletRequest req, HttpServletResponse resp) throws IOException {
            String path = req.getRequestURI();
            SourceCallback callback = (SourceCallback)HTTPMockServer.this.pathToCallback.get(path);
            long expectHeaderReceivedAtTimestamp = 0L;
            long continueResponseSentAtTimestamp = 0L;
            if (callback == null) {
                resp.setStatus(404);
                resp.getWriter().write("Not Found");
                return;
            }
            String expectHeader = req.getHeader("Expect");
            if (expectHeader != null && expectHeader.equalsIgnoreCase("100-continue")) {
                expectHeaderReceivedAtTimestamp = System.currentTimeMillis();
                resp.setStatus(100);
                resp.flushBuffer();
                continueResponseSentAtTimestamp = System.currentTimeMillis();
            }
            byte[] requestBody = this.toByteArray((InputStream)req.getInputStream());
            long requestBodyReceivedAtTimestamp = System.currentTimeMillis();
            HTTPMockServerResponse mockResponse = DelegateToFlowTransformer.delegate((SourceCallback<InputStream, HTTPMockRequestAttributes>)callback, requestBody);
            byte[] responseBody = mockResponse.getBody() != null ? this.toByteArray((InputStream)mockResponse.getBody().getValue()) : new byte[]{};
            resp.setStatus(mockResponse.getStatusCode().intValue());
            resp.setContentLength(responseBody.length);
            resp.setCharacterEncoding("UTF-8");
            resp.setContentType("application/json");
            resp.addHeader("X-Expect-Header-Time", String.valueOf(expectHeaderReceivedAtTimestamp));
            resp.addHeader("X-Continue-Sent-Time", String.valueOf(continueResponseSentAtTimestamp));
            resp.addHeader("X-Body-Received-Time", String.valueOf(requestBodyReceivedAtTimestamp));
            mockResponse.getHeaders().entrySet().forEach(entry -> resp.addHeader((String)entry.getKey(), (String)entry.getValue()));
            try (ServletOutputStream os = resp.getOutputStream();){
                os.write(responseBody);
                os.flush();
            }
        }

        private byte[] toByteArray(InputStream input) throws IOException {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((nRead = input.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            return buffer.toByteArray();
        }
    }

    private class MockServlet
    extends HttpServlet {
        private MockServlet() {
        }

        protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
            this.handle(req, resp);
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
            this.handle(req, resp);
        }

        private void handle(HttpServletRequest req, HttpServletResponse resp) throws IOException {
            String path = req.getRequestURI();
            SourceCallback callback = (SourceCallback)HTTPMockServer.this.pathToCallback.get(path);
            if (callback == null) {
                resp.setStatus(404);
                resp.getWriter().write("Not Found");
                return;
            }
            byte[] requestBody = this.toByteArray((InputStream)req.getInputStream());
            HTTPMockServerResponse mockResponse = DelegateToFlowTransformer.delegate((SourceCallback<InputStream, HTTPMockRequestAttributes>)callback, requestBody);
            byte[] responseBody = mockResponse.getBody() != null ? this.toByteArray((InputStream)mockResponse.getBody().getValue()) : new byte[]{};
            resp.setStatus(mockResponse.getStatusCode().intValue());
            resp.setContentLength(responseBody.length);
            resp.setCharacterEncoding("UTF-8");
            resp.setContentType("application/json");
            mockResponse.getHeaders().entrySet().forEach(entry -> resp.addHeader((String)entry.getKey(), (String)entry.getValue()));
            try (ServletOutputStream os = resp.getOutputStream();){
                os.write(responseBody);
                os.flush();
            }
        }

        private byte[] toByteArray(InputStream input) throws IOException {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((nRead = input.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            return buffer.toByteArray();
        }
    }

    public class StubRemover {
        private final String path;

        public StubRemover(String path) {
            this.path = path;
        }

        public void removeStub() {
            HTTPMockServer.this.pathToCallback.remove(this.path);
            LOGGER.info("Removed handler for path: {}", (Object)this.path);
        }
    }
}

