/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.extensions.http.mock.internal.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.test.extensions.http.mock.internal.HTTPMockErrors;
import org.mule.test.extensions.http.mock.internal.client.HTTPMockClient;
import org.mule.test.extensions.http.mock.internal.client.HttpClientResponseAttributes;

public class HTTPMockClientOperations {
    @MediaType(value="*/*", strict=false)
    public void doGet(@Connection HTTPMockClient client, String url, final CompletionCallback<InputStream, HttpClientResponseAttributes> callback) {
        Request request = new Request.Builder().url(url).build();
        client.mock().newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                callback.error((Throwable)new ModuleException("Error sending GET", (ErrorTypeDefinition)HTTPMockErrors.ERROR_ON_GET, (Throwable)e));
            }

            public void onResponse(Call call, Response response) {
                HttpClientResponseAttributes attrs = new HttpClientResponseAttributes();
                attrs.setStatusCode(response.code());
                attrs.setReasonPhrase(response.message());
                MultiMap headers = new MultiMap();
                response.headers().forEach(pair -> {
                    String cfr_ignored_0 = (String)headers.put(pair.getFirst(), pair.getSecond());
                });
                attrs.setHeaders((MultiMap<String, String>)headers);
                InputStream body = Objects.requireNonNull(response.body()).byteStream();
                Result result = Result.builder().attributes((Object)attrs).output((Object)body).build();
                callback.success(result);
            }
        });
    }

    @MediaType(value="*/*", strict=false)
    public void doPost(@Connection HTTPMockClient client, String url, String payload, MultiMap<String, String> requestHeaders, final CompletionCallback<InputStream, HttpClientResponseAttributes> callback) {
        RequestBody requestBody = RequestBody.create((String)payload, (okhttp3.MediaType)okhttp3.MediaType.parse((String)"application/json"));
        Request.Builder requestBuilder = new Request.Builder().url(url).post(requestBody);
        if (requestHeaders != null) {
            requestHeaders.forEach((arg_0, arg_1) -> ((Request.Builder)requestBuilder).addHeader(arg_0, arg_1));
        }
        Request request = requestBuilder.build();
        client.mock().newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                callback.error((Throwable)e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                HttpClientResponseAttributes attrs = new HttpClientResponseAttributes();
                attrs.setStatusCode(response.code());
                attrs.setReasonPhrase(response.message());
                MultiMap headers = new MultiMap();
                response.headers().forEach(pair -> {
                    String cfr_ignored_0 = (String)headers.put(pair.getFirst(), pair.getSecond());
                });
                attrs.setHeaders((MultiMap<String, String>)headers);
                InputStream body = Objects.requireNonNull(response.body()).byteStream();
                Result result = Result.builder().attributes((Object)attrs).output((Object)body).build();
                callback.success(result);
            }
        });
    }
}

