/*
 * Decompiled with CFR 0.152.
 */
package extension.org.mule.soap.it;

import extension.org.mule.soap.it.TestServiceProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.soap.ContextAwareMessageDispatcherProvider;
import org.mule.runtime.extension.api.soap.DispatchingContext;
import org.mule.runtime.extension.api.soap.SoapServiceProvider;
import org.mule.runtime.extension.api.soap.message.MessageDispatcher;
import org.mule.runtime.soap.api.message.dispatcher.HttpConfigBasedMessageDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="http-extensions-client-provider")
public class TestExtensionsClientHttpDispatcherProvider
extends ContextAwareMessageDispatcherProvider<MessageDispatcher> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestExtensionsClientHttpDispatcherProvider.class);
    private static final String INVALID_REQUESTER_NAME = "invalid";
    @Parameter
    private String requesterConfig;

    public MessageDispatcher connect(DispatchingContext ctx) {
        return new HttpConfigBasedMessageDispatcher(this.requesterConfig, ctx.getExtensionsClient());
    }

    public void disconnect(MessageDispatcher connection) {
        LifecycleUtils.disposeIfNeeded((Object)connection, (Logger)LOGGER);
    }

    public ConnectionValidationResult validate(MessageDispatcher connection, SoapServiceProvider provider) {
        if (INVALID_REQUESTER_NAME.equals(this.requesterConfig)) {
            return ConnectionValidationResult.failure((String)"invalid requester name", (Exception)new Exception());
        }
        if (provider instanceof TestServiceProvider && ((TestServiceProvider)provider).getPort().equals("invalidPort")) {
            return ConnectionValidationResult.failure((String)"invalid port name", (Exception)new Exception());
        }
        return ConnectionValidationResult.success();
    }
}

