/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.marvel.drstrange;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.reference.FlowReference;
import org.mule.runtime.extension.api.annotation.param.stereotype.Stereotype;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.route.Chain;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.sdk.api.annotation.param.Optional;
import org.mule.sdk.api.annotation.param.stereotype.ComponentId;
import org.mule.test.marvel.drstrange.CustomErrorException;
import org.mule.test.marvel.drstrange.CustomErrorProvider;
import org.mule.test.marvel.drstrange.DrStrange;
import org.mule.test.marvel.drstrange.DrStrangeErrorTypeDefinition;
import org.mule.test.marvel.drstrange.MysticConnection;
import org.mule.test.marvel.drstrange.ReferableOperationStereotypeDefinition;
import org.mule.test.marvel.model.Relic;

public class DrStrangeOperations {
    @Inject
    private ConfigurationComponentLocator locator;

    @MediaType(value="text/plain")
    public String seekStream(@Connection MysticConnection connection, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="#[payload]") InputStream stream, int position) throws IOException {
        Preconditions.checkArgument((boolean)(stream instanceof CursorStream), (String)"Stream was not cursored");
        CursorStream cursor = (CursorStream)stream;
        cursor.seek((long)position);
        return this.readStream(connection, (InputStream)cursor);
    }

    @Throws(value={CustomErrorProvider.class})
    @MediaType(value="text/plain")
    public String readStream(@org.mule.sdk.api.annotation.param.Connection MysticConnection connection, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="#[payload]") InputStream stream) throws IOException {
        try {
            return IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new CustomErrorException(e, DrStrangeErrorTypeDefinition.CUSTOM_ERROR);
        }
    }

    @MediaType(value="text/plain")
    public InputStream toStream(@Connection MysticConnection connection, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="#[payload]") String data) {
        return connection.manage(new ByteArrayInputStream(data.getBytes()));
    }

    @MediaType(value="text/plain")
    public InputStream objectToStream(@Connection MysticConnection connection, @Optional(defaultValue="#[payload]") Object data) {
        return connection.manage((InputStream)data);
    }

    public void crashCar(@Config DrStrange dr) {
        throw new RuntimeException();
    }

    @Stereotype(value=ReferableOperationStereotypeDefinition.class)
    public void withFlowReference(@org.mule.sdk.api.annotation.param.Config DrStrange dr, @org.mule.runtime.extension.api.annotation.param.Optional @FlowReference String flowRef, @ComponentId String name) {
        if (!StringUtils.isBlank((CharSequence)flowRef) && !this.locator.find(Location.builder().globalName(flowRef).build()).isPresent()) {
            throw new IllegalArgumentException("The referenced flow does not exist in this application");
        }
    }

    public List<String> readObjectStream(@Content Iterator<String> iteratorValues) {
        LinkedList<String> objects = new LinkedList<String>();
        while (iteratorValues.hasNext()) {
            objects.add(iteratorValues.next());
        }
        return objects;
    }

    public PagingProvider<MysticConnection, String> sayMagicWords(final @Content List<String> values, final int fetchSize) {
        final AtomicInteger index = new AtomicInteger(0);
        return new PagingProvider<MysticConnection, String>(){
            private int timesClosed = 0;

            public List<String> getPage(MysticConnection connection) {
                int i = index.get();
                if (i >= values.size()) {
                    return Collections.emptyList();
                }
                List<String> words = values.subList(i, i + fetchSize);
                index.addAndGet(fetchSize);
                return words;
            }

            public java.util.Optional<Integer> getTotalResults(MysticConnection connection) {
                return java.util.Optional.of(values.size());
            }

            public void close(MysticConnection connection) throws MuleException {
                ++this.timesClosed;
                if (this.timesClosed > 1) {
                    throw new RuntimeException("Expected to be closed only once but was called twice");
                }
            }
        };
    }

    public PagingProvider<MysticConnection, Relic> getRelics(final StreamingHelper streamingHelper) {
        return new PagingProvider<MysticConnection, Relic>(){
            private int currentPage = 1;
            private final int PAGES = 4;

            public List<Relic> getPage(MysticConnection connection) {
                if (this.currentPage == 4) {
                    return Collections.emptyList();
                }
                ++this.currentPage;
                return new ArrayList<Relic>(){
                    {
                        this.add(this.getResolvedRelic("cloak"));
                        this.add(this.getResolvedRelic("boots"));
                        this.add(this.getResolvedRelic("staff"));
                    }
                };
            }

            private Relic getResolvedRelic(String description) {
                return new Relic(streamingHelper.resolveCursorProvider((Object)new ByteArrayInputStream(description.getBytes())));
            }

            public java.util.Optional<Integer> getTotalResults(MysticConnection connection) {
                return java.util.Optional.empty();
            }

            public void close(MysticConnection connection) throws MuleException {
            }
        };
    }

    @MediaType(value="text/plain")
    public void scopeverse(Chain operations, CompletionCallback<Object, Object> callback, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="#[payload]") TypedValue<Object> payload, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="#[attributes]") TypedValue<Object> attributes) {
        try {
            IOUtils.toString((InputStream)((InputStream)payload.getValue()), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        operations.process(payload, attributes, result -> {
            try {
                IOUtils.toString((InputStream)((InputStream)((CursorStreamProvider)result.getOutput()).openCursor()), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                callback.error((Throwable)e);
            }
            callback.success(result);
        }, (error, previous) -> callback.error(error));
    }
}

