/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.marvel.ironman;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.display.PathModel;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.extension.api.annotation.execution.Execution;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.Path;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.sdk.api.annotation.param.display.ClassValue;
import org.mule.sdk.api.runtime.operation.Result;
import org.mule.test.marvel.ironman.IronMan;
import org.mule.test.marvel.model.Missile;
import org.mule.test.marvel.model.Villain;

public class IronManOperations
implements Initialisable,
Disposable {
    public static final int MISSILE_TRAVEL_TIME = 200;
    public static final String FLIGHT_PLAN = "Go Straight";
    private ScheduledExecutorService executorService;

    public void initialise() throws InitialisationException {
        this.executorService = Executors.newSingleThreadScheduledExecutor();
    }

    public void dispose() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    @MediaType(value="text/plain")
    public void fireMissile(@Config IronMan ironMan, @Connection Missile missile, Villain at, org.mule.sdk.api.runtime.process.CompletionCallback<String, Void> callback) {
        Runnable launch = () -> {
            try {
                ironMan.track(missile);
                callback.success(Result.builder().output((Object)missile.fireAt(at)).build());
            }
            catch (Exception e) {
                callback.error((Throwable)e);
            }
        };
        this.executorService.schedule(launch, 200L, TimeUnit.MILLISECONDS);
    }

    @MediaType(value="text/plain")
    public void fireMissileMishap(@Config IronMan ironMan, @org.mule.sdk.api.annotation.param.Connection Missile missile, Villain at, CompletionCallback<String, Void> callback) {
        throw new IllegalStateException("Ultron jammed the missile system!");
    }

    @MediaType(value="text/plain")
    public void fireMissileEpicShot(@Config IronMan ironMan, @Connection Missile missile, Villain at, org.mule.sdk.api.runtime.process.CompletionCallback<String, Void> callback) {
        try {
            ironMan.track(missile);
            callback.success(Result.builder().output((Object)missile.fireAt(at)).build());
        }
        catch (Exception e) {
            callback.error((Throwable)e);
        }
    }

    @MediaType(value="text/plain")
    public String findInstructions(@Optional @Path(acceptedFileExtensions={"xml"}, location=PathModel.Location.EMBEDDED) String instructionsFile, @Optional @ClassValue(extendsOrImplements={"com.starkindustries.Reader"}) String readerClass) {
        return instructionsFile;
    }

    @Execution(value=ExecutionType.CPU_INTENSIVE)
    public void computeFlightPlan(@Config IronMan ironMan, CompletionCallback<Void, Void> callback) {
        Runnable launch = () -> {
            callback.success(org.mule.runtime.extension.api.runtime.operation.Result.builder().build());
            ironMan.setFlightPlan(FLIGHT_PLAN);
        };
        this.executorService.schedule(launch, 200L, TimeUnit.MILLISECONDS);
    }
}

