/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.metadata.extension;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.execution.OnError;
import org.mule.runtime.extension.api.annotation.execution.OnSuccess;
import org.mule.runtime.extension.api.annotation.metadata.MetadataScope;
import org.mule.runtime.extension.api.annotation.metadata.fixed.InputJsonType;
import org.mule.runtime.extension.api.annotation.metadata.fixed.InputXmlType;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.source.EmitsResponse;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.tck.message.StringAttributes;
import org.mule.test.metadata.extension.resolver.JavaOutputStaticTypeResolver;

@Alias(value="custom-static-metadata")
@EmitsResponse
@MetadataScope(outputResolver=JavaOutputStaticTypeResolver.class)
@MediaType(value="application/java", strict=false)
public class CustomStaticMetadataSource
extends Source<Object, StringAttributes> {
    public static String onSuccessResult;
    public static String onErrorResult;

    public void onStart(SourceCallback sourceCallback) throws MuleException {
        sourceCallback.handle(Result.builder().output((Object)"something").build());
    }

    @OnError
    public void onError(@InputJsonType(schema="person-schema.json") InputStream person, SourceCallbackContext cc) {
        try {
            onErrorResult = IOUtils.toString((InputStream)person, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @OnSuccess
    public void onSuccess(@InputXmlType(schema="order.xsd", qname="shiporder") InputStream order, SourceCallbackContext cc) {
        try {
            onSuccessResult = IOUtils.toString((InputStream)order, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void onStop() {
    }
}

