/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb.disk.journal;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.Adler32;
import org.apache.activemq.store.kahadb.disk.journal.CallerBufferingDataFileAppender;
import org.apache.activemq.store.kahadb.disk.journal.DataFile;
import org.apache.activemq.store.kahadb.disk.journal.DataFileAccessor;
import org.apache.activemq.store.kahadb.disk.journal.DataFileAccessorPool;
import org.apache.activemq.store.kahadb.disk.journal.DataFileAppender;
import org.apache.activemq.store.kahadb.disk.journal.FileAppender;
import org.apache.activemq.store.kahadb.disk.journal.Location;
import org.apache.activemq.store.kahadb.disk.journal.ReplicationTarget;
import org.apache.activemq.store.kahadb.disk.util.LinkedNode;
import org.apache.activemq.store.kahadb.disk.util.LinkedNodeList;
import org.apache.activemq.store.kahadb.disk.util.Sequence;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.DataByteArrayInputStream;
import org.apache.activemq.util.DataByteArrayOutputStream;
import org.apache.activemq.util.IOHelper;
import org.apache.activemq.util.RecoverableRandomAccessFile;
import org.apache.activemq.util.ThreadPoolUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Journal {
    public static final String CALLER_BUFFER_APPENDER = "org.apache.kahadb.journal.CALLER_BUFFER_APPENDER";
    public static final boolean callerBufferAppender = Boolean.parseBoolean(System.getProperty("org.apache.kahadb.journal.CALLER_BUFFER_APPENDER", "false"));
    private static final int PREALLOC_CHUNK_SIZE = 0x100000;
    public static final int RECORD_HEAD_SPACE = 5;
    public static final byte USER_RECORD_TYPE = 1;
    public static final byte BATCH_CONTROL_RECORD_TYPE = 2;
    public static final byte[] BATCH_CONTROL_RECORD_MAGIC = Journal.bytes("WRITE BATCH");
    public static final int BATCH_CONTROL_RECORD_SIZE = 5 + BATCH_CONTROL_RECORD_MAGIC.length + 4 + 8;
    public static final byte[] BATCH_CONTROL_RECORD_HEADER = Journal.createBatchControlRecordHeader();
    public static final byte[] EMPTY_BATCH_CONTROL_RECORD = Journal.createEmptyBatchControlRecordHeader();
    public static final int EOF_INT = ByteBuffer.wrap(new byte[]{45, 113, 77, 97}).getInt();
    public static final byte EOF_EOT = 52;
    public static final byte[] EOF_RECORD = Journal.createEofBatchAndLocationRecord();
    private ScheduledExecutorService scheduler;
    public static final String DEFAULT_DIRECTORY = ".";
    public static final String DEFAULT_ARCHIVE_DIRECTORY = "data-archive";
    public static final String DEFAULT_FILE_PREFIX = "db-";
    public static final String DEFAULT_FILE_SUFFIX = ".log";
    public static final int DEFAULT_MAX_FILE_LENGTH = 0x2000000;
    public static final int DEFAULT_CLEANUP_INTERVAL = 30000;
    public static final int DEFAULT_MAX_WRITE_BATCH_SIZE = 0x400000;
    private static final Logger LOG = LoggerFactory.getLogger(Journal.class);
    protected final Map<WriteKey, WriteCommand> inflightWrites = new ConcurrentHashMap<WriteKey, WriteCommand>();
    protected File directory = new File(".");
    protected File directoryArchive;
    private boolean directoryArchiveOverridden = false;
    protected String filePrefix = "db-";
    protected String fileSuffix = ".log";
    protected boolean started;
    protected int maxFileLength = 0x2000000;
    protected int writeBatchSize = 0x400000;
    protected FileAppender appender;
    protected DataFileAccessorPool accessorPool;
    protected Map<Integer, DataFile> fileMap = new HashMap<Integer, DataFile>();
    protected Map<File, DataFile> fileByFileMap = new LinkedHashMap<File, DataFile>();
    protected LinkedNodeList<DataFile> dataFiles = new LinkedNodeList();
    protected final AtomicReference<Location> lastAppendLocation = new AtomicReference();
    protected ScheduledFuture cleanupTask;
    protected AtomicLong totalLength = new AtomicLong();
    protected boolean archiveDataLogs;
    private ReplicationTarget replicationTarget;
    protected boolean checksum;
    protected boolean checkForCorruptionOnStartup;
    protected boolean enableAsyncDiskSync = true;
    private int nextDataFileId = 1;
    private Object dataFileIdLock = new Object();
    private final AtomicReference<DataFile> currentDataFile = new AtomicReference<Object>(null);
    private volatile DataFile nextDataFile;
    protected PreallocationScope preallocationScope = PreallocationScope.ENTIRE_JOURNAL;
    protected PreallocationStrategy preallocationStrategy = PreallocationStrategy.SPARSE_FILE;
    private File osKernelCopyTemplateFile = null;
    private ByteBuffer preAllocateDirectBuffer = null;
    private long cleanupInterval = 30000L;
    protected JournalDiskSyncStrategy journalDiskSyncStrategy = JournalDiskSyncStrategy.ALWAYS;
    private DataFileRemovedListener dataFileRemovedListener;
    private Runnable preAllocateNextDataFileTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (Journal.this.nextDataFile == null) {
                Object object = Journal.this.dataFileIdLock;
                synchronized (object) {
                    try {
                        Journal.this.nextDataFile = Journal.this.newDataFile();
                    }
                    catch (IOException e) {
                        LOG.warn("Failed to proactively allocate data file", (Throwable)e);
                    }
                }
            }
        }
    };
    private volatile Future preAllocateNextDataFileFuture;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void corruptRecoveryLocation(Location recoveryPosition) throws IOException {
        DataFile dataFile = this.getDataFile(recoveryPosition);
        DataFileAccessor reader = this.accessorPool.openDataFileAccessor(dataFile);
        try {
            RandomAccessFile randomAccessFile = reader.getRaf().getRaf();
            randomAccessFile.seek(recoveryPosition.getOffset() + 1);
            byte[] data = new byte[this.getWriteBatchSize()];
            ByteSequence bs = new ByteSequence(data, 0, randomAccessFile.read(data));
            int nextOffset = 0;
            nextOffset = this.findNextBatchRecord(bs, randomAccessFile) >= 0 ? Math.toIntExact(randomAccessFile.getFilePointer() - (long)bs.remaining()) : Math.toIntExact(randomAccessFile.length());
            Sequence sequence = new Sequence(recoveryPosition.getOffset(), nextOffset - 1);
            LOG.warn("Corrupt journal records found in '{}' between offsets: {}", (Object)dataFile.getFile(), (Object)sequence);
            recoveryPosition.setOffset(nextOffset);
            recoveryPosition.setSize(-1);
            dataFile.corruptedBlocks.add(sequence);
        }
        catch (IOException iOException) {
        }
        finally {
            this.accessorPool.closeDataFileAccessor(reader);
        }
    }

    public DataFileAccessorPool getAccessorPool() {
        return this.accessorPool;
    }

    public void allowIOResumption() {
        if (this.appender instanceof DataFileAppender) {
            DataFileAppender dataFileAppender = (DataFileAppender)this.appender;
            dataFileAppender.shutdown = false;
        }
    }

    public void setCleanupInterval(long cleanupInterval) {
        this.cleanupInterval = cleanupInterval;
    }

    public long getCleanupInterval() {
        return this.cleanupInterval;
    }

    private static byte[] createBatchControlRecordHeader() {
        byte[] byArray;
        DataByteArrayOutputStream os = new DataByteArrayOutputStream();
        try {
            os.writeInt(BATCH_CONTROL_RECORD_SIZE);
            os.writeByte(2);
            os.write(BATCH_CONTROL_RECORD_MAGIC);
            ByteSequence sequence = os.toByteSequence();
            sequence.compact();
            byArray = sequence.getData();
        }
        catch (Throwable throwable) {
            try {
                try {
                    os.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not create batch control record header.", e);
            }
        }
        os.close();
        return byArray;
    }

    private static byte[] createEmptyBatchControlRecordHeader() {
        byte[] byArray;
        DataByteArrayOutputStream os = new DataByteArrayOutputStream();
        try {
            os.writeInt(BATCH_CONTROL_RECORD_SIZE);
            os.writeByte(2);
            os.write(BATCH_CONTROL_RECORD_MAGIC);
            os.writeInt(0);
            os.writeLong(0L);
            ByteSequence sequence = os.toByteSequence();
            sequence.compact();
            byArray = sequence.getData();
        }
        catch (Throwable throwable) {
            try {
                try {
                    os.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not create empty batch control record header.", e);
            }
        }
        os.close();
        return byArray;
    }

    private static byte[] createEofBatchAndLocationRecord() {
        byte[] byArray;
        DataByteArrayOutputStream os = new DataByteArrayOutputStream();
        try {
            os.writeInt(EOF_INT);
            os.writeByte(52);
            ByteSequence sequence = os.toByteSequence();
            sequence.compact();
            byArray = sequence.getData();
        }
        catch (Throwable throwable) {
            try {
                try {
                    os.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not create eof header.", e);
            }
        }
        os.close();
        return byArray;
    }

    public synchronized void start() throws IOException {
        if (this.started) {
            return;
        }
        long start = System.currentTimeMillis();
        this.accessorPool = new DataFileAccessorPool(this);
        this.started = true;
        this.appender = callerBufferAppender ? new CallerBufferingDataFileAppender(this) : new DataFileAppender(this);
        File[] files = this.directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String n) {
                return dir.equals(Journal.this.directory) && n.startsWith(Journal.this.filePrefix) && n.endsWith(Journal.this.fileSuffix);
            }
        });
        if (files != null) {
            for (File file : files) {
                try {
                    String n = file.getName();
                    String numStr = n.substring(this.filePrefix.length(), n.length() - this.fileSuffix.length());
                    int num = Integer.parseInt(numStr);
                    DataFile dataFile = new DataFile(file, num);
                    this.fileMap.put(dataFile.getDataFileId(), dataFile);
                    this.totalLength.addAndGet(dataFile.getLength());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            LinkedList<DataFile> l = new LinkedList<DataFile>(this.fileMap.values());
            Collections.sort(l);
            for (DataFile df : l) {
                if (df.getLength() == 0) {
                    LOG.info("ignoring zero length, partially initialised journal data file: " + df);
                    continue;
                }
                if (l.getLast().equals(df) && this.isUnusedPreallocated(df)) continue;
                this.dataFiles.addLast(df);
                this.fileByFileMap.put(df.getFile(), df);
                if (!this.isCheckForCorruptionOnStartup()) continue;
                this.lastAppendLocation.set(this.recoveryCheck(df));
            }
        }
        if (this.preallocationScope != PreallocationScope.NONE) {
            switch (this.preallocationStrategy) {
                case SPARSE_FILE: {
                    break;
                }
                case OS_KERNEL_COPY: {
                    this.osKernelCopyTemplateFile = this.createJournalTemplateFile();
                    break;
                }
                case CHUNKED_ZEROS: {
                    this.preAllocateDirectBuffer = this.allocateDirectBuffer(0x100000);
                    break;
                }
                case ZEROS: {
                    this.preAllocateDirectBuffer = this.allocateDirectBuffer(this.getMaxFileLength());
                }
            }
        }
        this.scheduler = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread schedulerThread = new Thread(r);
                schedulerThread.setName("ActiveMQ Journal Scheduled executor");
                schedulerThread.setDaemon(true);
                return schedulerThread;
            }
        });
        if (this.dataFiles.isEmpty()) {
            this.nextDataFileId = 1;
            this.rotateWriteFile();
        } else {
            this.currentDataFile.set(this.dataFiles.getTail());
            this.nextDataFileId = this.currentDataFile.get().dataFileId + 1;
        }
        if (this.lastAppendLocation.get() == null) {
            DataFile df = this.dataFiles.getTail();
            this.lastAppendLocation.set(this.recoveryCheck(df));
        }
        int lastFileLength = this.dataFiles.getTail().getLength();
        if (this.totalLength.get() > (long)lastFileLength && this.lastAppendLocation.get().getOffset() > 0) {
            this.totalLength.addAndGet(this.lastAppendLocation.get().getOffset() - lastFileLength);
        }
        this.cleanupTask = this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                Journal.this.cleanup();
            }
        }, this.cleanupInterval, this.cleanupInterval, TimeUnit.MILLISECONDS);
        long end = System.currentTimeMillis();
        LOG.trace("Startup took: " + (end - start) + " ms");
    }

    private ByteBuffer allocateDirectBuffer(int size) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(size);
        buffer.put(EOF_RECORD);
        return buffer;
    }

    public void preallocateEntireJournalDataFile(RecoverableRandomAccessFile file) {
        if (PreallocationScope.NONE != this.preallocationScope) {
            try {
                if (PreallocationStrategy.OS_KERNEL_COPY == this.preallocationStrategy) {
                    this.doPreallocationKernelCopy(file);
                } else if (PreallocationStrategy.ZEROS == this.preallocationStrategy) {
                    this.doPreallocationZeros(file);
                } else if (PreallocationStrategy.CHUNKED_ZEROS == this.preallocationStrategy) {
                    this.doPreallocationChunkedZeros(file);
                } else {
                    this.doPreallocationSparseFile(file);
                }
            }
            catch (Throwable continueWithNoPrealloc) {
                LOG.error("cound not preallocate journal data file", continueWithNoPrealloc);
            }
        }
    }

    private void doPreallocationSparseFile(RecoverableRandomAccessFile file) {
        ByteBuffer journalEof = ByteBuffer.wrap(EOF_RECORD);
        try {
            FileChannel channel = file.getChannel();
            channel.position(0L);
            channel.write(journalEof);
            channel.position(this.maxFileLength - 5);
            journalEof.rewind();
            channel.write(journalEof);
            channel.force(false);
            channel.position(0L);
        }
        catch (ClosedByInterruptException ignored) {
            LOG.trace("Could not preallocate journal file with sparse file", (Throwable)ignored);
        }
        catch (IOException e) {
            LOG.error("Could not preallocate journal file with sparse file", (Throwable)e);
        }
    }

    private void doPreallocationZeros(RecoverableRandomAccessFile file) {
        this.preAllocateDirectBuffer.rewind();
        try {
            FileChannel channel = file.getChannel();
            channel.write(this.preAllocateDirectBuffer);
            channel.force(false);
            channel.position(0L);
        }
        catch (ClosedByInterruptException ignored) {
            LOG.trace("Could not preallocate journal file with zeros", (Throwable)ignored);
        }
        catch (IOException e) {
            LOG.error("Could not preallocate journal file with zeros", (Throwable)e);
        }
    }

    private void doPreallocationKernelCopy(RecoverableRandomAccessFile file) {
        try (RandomAccessFile templateRaf = new RandomAccessFile(this.osKernelCopyTemplateFile, "rw");){
            templateRaf.getChannel().transferTo(0L, this.getMaxFileLength(), file.getChannel());
        }
        catch (ClosedByInterruptException ignored) {
            LOG.trace("Could not preallocate journal file with kernel copy", (Throwable)ignored);
        }
        catch (FileNotFoundException e) {
            LOG.error("Could not find the template file on disk at " + this.osKernelCopyTemplateFile.getAbsolutePath(), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("Could not transfer the template file to journal, transferFile=" + this.osKernelCopyTemplateFile.getAbsolutePath(), (Throwable)e);
        }
    }

    private File createJournalTemplateFile() {
        String fileName = "db-log.template";
        File rc = new File(this.directory, fileName);
        try (RandomAccessFile templateRaf = new RandomAccessFile(rc, "rw");){
            templateRaf.getChannel().write(ByteBuffer.wrap(EOF_RECORD));
            templateRaf.setLength(this.maxFileLength);
            templateRaf.getChannel().force(true);
        }
        catch (FileNotFoundException e) {
            LOG.error("Could not find the template file on disk at " + this.osKernelCopyTemplateFile.getAbsolutePath(), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("Could not transfer the template file to journal, transferFile=" + this.osKernelCopyTemplateFile.getAbsolutePath(), (Throwable)e);
        }
        return rc;
    }

    private void doPreallocationChunkedZeros(RecoverableRandomAccessFile file) {
        this.preAllocateDirectBuffer.limit(this.preAllocateDirectBuffer.capacity());
        this.preAllocateDirectBuffer.rewind();
        try {
            int writeLen;
            FileChannel channel = file.getChannel();
            for (int remLen = this.maxFileLength; remLen > 0; remLen -= writeLen) {
                if (remLen < this.preAllocateDirectBuffer.remaining()) {
                    this.preAllocateDirectBuffer.limit(remLen);
                }
                writeLen = channel.write(this.preAllocateDirectBuffer);
                this.preAllocateDirectBuffer.rewind();
            }
            channel.force(false);
            channel.position(0L);
        }
        catch (ClosedByInterruptException ignored) {
            LOG.trace("Could not preallocate journal file with zeros", (Throwable)ignored);
        }
        catch (IOException e) {
            LOG.error("Could not preallocate journal file with zeros! Will continue without preallocation", (Throwable)e);
        }
    }

    private static byte[] bytes(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUnusedPreallocated(DataFile dataFile) throws IOException {
        if (this.preallocationScope == PreallocationScope.ENTIRE_JOURNAL_ASYNC) {
            DataFileAccessor reader = this.accessorPool.openDataFileAccessor(dataFile);
            try {
                byte[] firstFewBytes = new byte[BATCH_CONTROL_RECORD_HEADER.length];
                reader.readFully(0L, firstFewBytes);
                ByteSequence bs = new ByteSequence(firstFewBytes);
                boolean bl = bs.startsWith(EOF_RECORD);
                return bl;
            }
            catch (Exception exception) {
            }
            finally {
                this.accessorPool.closeDataFileAccessor(reader);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Location recoveryCheck(DataFile dataFile) throws IOException {
        Location location;
        block9: {
            location = new Location();
            location.setDataFileId(dataFile.getDataFileId());
            location.setOffset(0);
            DataFileAccessor reader = this.accessorPool.openDataFileAccessor(dataFile);
            try {
                Sequence sequence;
                RandomAccessFile randomAccessFile = reader.getRaf().getRaf();
                randomAccessFile.seek(0L);
                long totalFileLength = randomAccessFile.length();
                byte[] data = new byte[this.getWriteBatchSize()];
                ByteSequence bs = new ByteSequence(data, 0, randomAccessFile.read(data));
                while (true) {
                    int size;
                    if ((size = this.checkBatchRecord(bs, randomAccessFile)) > 0 && (long)(location.getOffset() + BATCH_CONTROL_RECORD_SIZE + size) <= totalFileLength) {
                        location.setOffset(location.getOffset() + BATCH_CONTROL_RECORD_SIZE + size);
                        continue;
                    }
                    if (size == 0 && (long)(location.getOffset() + EOF_RECORD.length + size) <= totalFileLength) {
                        break block9;
                    }
                    sequence = new Sequence(location.getOffset());
                    if (this.findNextBatchRecord(bs, randomAccessFile) < 0) break;
                    int nextOffset = Math.toIntExact(randomAccessFile.getFilePointer() - (long)bs.remaining());
                    sequence.setLast(nextOffset - 1);
                    dataFile.corruptedBlocks.add(sequence);
                    LOG.warn("Corrupt journal records found in '{}' between offsets: {}", (Object)dataFile.getFile(), (Object)sequence);
                    location.setOffset(nextOffset);
                }
                sequence.setLast(Math.toIntExact(randomAccessFile.getFilePointer()));
                dataFile.corruptedBlocks.add(sequence);
                LOG.warn("Corrupt journal records found in '{}' from offset: {} to EOF", (Object)dataFile.getFile(), (Object)sequence);
            }
            catch (IOException e) {
                LOG.trace("exception on recovery check of: " + dataFile + ", at " + location, (Throwable)e);
            }
            finally {
                this.accessorPool.closeDataFileAccessor(reader);
            }
        }
        int existingLen = dataFile.getLength();
        dataFile.setLength(location.getOffset());
        if (existingLen > dataFile.getLength()) {
            this.totalLength.addAndGet(dataFile.getLength() - existingLen);
        }
        return location;
    }

    private int findNextBatchRecord(ByteSequence bs, RandomAccessFile reader) throws IOException {
        ByteSequence header = new ByteSequence(BATCH_CONTROL_RECORD_HEADER);
        int pos = 0;
        while (true) {
            if ((pos = bs.indexOf(header, 0)) >= 0) {
                bs.setOffset(bs.offset + pos);
                return pos;
            }
            if (bs.length != bs.data.length) {
                return -1;
            }
            bs.setOffset(bs.length - BATCH_CONTROL_RECORD_HEADER.length);
            bs.reset();
            bs.setLength(bs.length + reader.read(bs.data, bs.length, bs.data.length - BATCH_CONTROL_RECORD_HEADER.length));
        }
    }

    private int checkBatchRecord(ByteSequence bs, RandomAccessFile reader) throws IOException {
        this.ensureAvailable(bs, reader, EOF_RECORD.length);
        if (bs.startsWith(EOF_RECORD)) {
            return 0;
        }
        this.ensureAvailable(bs, reader, BATCH_CONTROL_RECORD_SIZE);
        try (DataByteArrayInputStream controlIs = new DataByteArrayInputStream(bs);){
            for (int i = 0; i < BATCH_CONTROL_RECORD_HEADER.length; ++i) {
                if (controlIs.readByte() == BATCH_CONTROL_RECORD_HEADER[i]) continue;
                int n = -1;
                return n;
            }
            int size = controlIs.readInt();
            if (size < 0 || size > Integer.MAX_VALUE - (BATCH_CONTROL_RECORD_SIZE + EOF_RECORD.length)) {
                int n = -2;
                return n;
            }
            long expectedChecksum = controlIs.readLong();
            Adler32 checksum = null;
            if (this.isChecksum() && expectedChecksum > 0L) {
                checksum = new Adler32();
            }
            bs.setOffset(controlIs.position());
            int toRead = size;
            while (toRead > 0) {
                if (bs.remaining() >= toRead) {
                    if (checksum != null) {
                        checksum.update(bs.getData(), bs.getOffset(), toRead);
                    }
                    bs.setOffset(bs.offset + toRead);
                    toRead = 0;
                    continue;
                }
                if (bs.length != bs.data.length) {
                    int n = -3;
                    return n;
                }
                toRead -= bs.remaining();
                if (checksum != null) {
                    checksum.update(bs.getData(), bs.getOffset(), bs.remaining());
                }
                bs.setLength(reader.read(bs.data));
                bs.setOffset(0);
            }
            if (checksum != null && expectedChecksum != checksum.getValue()) {
                int n = -4;
                return n;
            }
            int n = size;
            return n;
        }
    }

    private void ensureAvailable(ByteSequence bs, RandomAccessFile reader, int required) throws IOException {
        if (bs.remaining() < required) {
            bs.reset();
            int read = reader.read(bs.data, bs.length, bs.data.length - bs.length);
            if (read < 0 && bs.remaining() == 0) {
                throw new EOFException("request for " + required + " bytes reached EOF");
            }
            bs.setLength(bs.length + read);
        }
    }

    void addToTotalLength(int size) {
        this.totalLength.addAndGet(size);
    }

    public long length() {
        return this.totalLength.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rotateWriteFile() throws IOException {
        Object object = this.dataFileIdLock;
        synchronized (object) {
            DataFile dataFile = this.nextDataFile;
            if (dataFile == null) {
                dataFile = this.newDataFile();
            }
            AtomicReference<DataFile> atomicReference = this.currentDataFile;
            synchronized (atomicReference) {
                this.fileMap.put(dataFile.getDataFileId(), dataFile);
                this.fileByFileMap.put(dataFile.getFile(), dataFile);
                this.dataFiles.addLast(dataFile);
                this.currentDataFile.set(dataFile);
            }
            this.nextDataFile = null;
        }
        if (PreallocationScope.ENTIRE_JOURNAL_ASYNC == this.preallocationScope) {
            this.preAllocateNextDataFileFuture = this.scheduler.submit(this.preAllocateNextDataFileTask);
        }
    }

    private DataFile newDataFile() throws IOException {
        int nextNum = this.nextDataFileId++;
        File file = this.getFile(nextNum);
        DataFile nextWriteFile = new DataFile(file, nextNum);
        this.preallocateEntireJournalDataFile(nextWriteFile.appendRandomAccessFile());
        return nextWriteFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataFile reserveDataFile() {
        Object object = this.dataFileIdLock;
        synchronized (object) {
            int nextNum = this.nextDataFileId++;
            File file = this.getFile(nextNum);
            DataFile reservedDataFile = new DataFile(file, nextNum);
            AtomicReference<DataFile> atomicReference = this.currentDataFile;
            synchronized (atomicReference) {
                this.fileMap.put(reservedDataFile.getDataFileId(), reservedDataFile);
                this.fileByFileMap.put(file, reservedDataFile);
                if (this.dataFiles.isEmpty()) {
                    this.dataFiles.addLast(reservedDataFile);
                } else {
                    this.dataFiles.getTail().linkBefore(reservedDataFile);
                }
            }
            return reservedDataFile;
        }
    }

    public File getFile(int nextNum) {
        String fileName = this.filePrefix + nextNum + this.fileSuffix;
        File file = new File(this.directory, fileName);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataFile getDataFile(Location item) throws IOException {
        Integer key = item.getDataFileId();
        DataFile dataFile = null;
        AtomicReference<DataFile> atomicReference = this.currentDataFile;
        synchronized (atomicReference) {
            dataFile = this.fileMap.get(key);
        }
        if (dataFile == null) {
            LOG.error("Looking for key " + key + " but not found in fileMap: " + this.fileMap);
            throw new IOException("Could not locate data file " + this.getFile(item.getDataFileId()));
        }
        return dataFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.cleanupTask.cancel(true);
            if (this.preAllocateNextDataFileFuture != null) {
                this.preAllocateNextDataFileFuture.cancel(true);
            }
            ThreadPoolUtils.shutdownGraceful(this.scheduler, 4000L);
            this.accessorPool.close();
        }
        this.appender.close();
        object = this.currentDataFile;
        synchronized (object) {
            this.fileMap.clear();
            this.fileByFileMap.clear();
            this.dataFiles.clear();
            this.lastAppendLocation.set(null);
            this.started = false;
        }
    }

    public synchronized void cleanup() {
        if (this.accessorPool != null) {
            this.accessorPool.disposeUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean delete() throws IOException {
        this.appender.close();
        this.accessorPool.close();
        boolean result = true;
        for (DataFile dataFile : this.fileMap.values()) {
            result &= dataFile.delete();
        }
        if (this.preAllocateNextDataFileFuture != null) {
            this.preAllocateNextDataFileFuture.cancel(true);
        }
        AtomicReference<DataFile> atomicReference = this.dataFileIdLock;
        synchronized (atomicReference) {
            if (this.nextDataFile != null) {
                this.nextDataFile.delete();
                this.nextDataFile = null;
            }
        }
        this.totalLength.set(0L);
        atomicReference = this.currentDataFile;
        synchronized (atomicReference) {
            this.fileMap.clear();
            this.fileByFileMap.clear();
            this.lastAppendLocation.set(null);
            this.dataFiles = new LinkedNodeList();
        }
        this.accessorPool = new DataFileAccessorPool(this);
        this.appender = new DataFileAppender(this);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataFiles(Set<Integer> files) throws IOException {
        for (Integer key : files) {
            if (key >= this.lastAppendLocation.get().getDataFileId()) continue;
            DataFile dataFile = null;
            AtomicReference<DataFile> atomicReference = this.currentDataFile;
            synchronized (atomicReference) {
                dataFile = this.fileMap.remove(key);
                if (dataFile != null) {
                    this.fileByFileMap.remove(dataFile.getFile());
                    dataFile.unlink();
                }
            }
            if (dataFile == null) continue;
            this.forceRemoveDataFile(dataFile);
        }
    }

    private void forceRemoveDataFile(DataFile dataFile) throws IOException {
        this.accessorPool.disposeDataFileAccessors(dataFile);
        this.totalLength.addAndGet(-dataFile.getLength());
        if (this.archiveDataLogs) {
            File directoryArchive = this.getDirectoryArchive();
            if (directoryArchive.exists()) {
                LOG.debug("Archive directory exists: {}", (Object)directoryArchive);
            } else {
                if (directoryArchive.isAbsolute() && LOG.isDebugEnabled()) {
                    LOG.debug("Archive directory [{}] does not exist - creating it now", (Object)directoryArchive.getAbsolutePath());
                }
                IOHelper.mkdirs(directoryArchive);
            }
            LOG.debug("Moving data file {} to {} ", (Object)dataFile, (Object)directoryArchive.getCanonicalPath());
            dataFile.move(directoryArchive);
            LOG.debug("Successfully moved data file");
        } else {
            LOG.debug("Deleting data file: {}", (Object)dataFile);
            if (dataFile.delete()) {
                LOG.debug("Discarded data file: {}", (Object)dataFile);
            } else {
                LOG.warn("Failed to discard data file : {}", (Object)dataFile.getFile());
            }
        }
        if (this.dataFileRemovedListener != null) {
            this.dataFileRemovedListener.fileRemoved(dataFile);
        }
    }

    public int getMaxFileLength() {
        return this.maxFileLength;
    }

    public void setMaxFileLength(int maxFileLength) {
        this.maxFileLength = maxFileLength;
    }

    public String toString() {
        return this.directory.toString();
    }

    public Location getNextLocation(Location location) throws IOException, IllegalStateException {
        return this.getNextLocation(location, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location getNextLocation(Location location, Location limit) throws IOException, IllegalStateException {
        Location cur = null;
        while (true) {
            AtomicReference<DataFile> atomicReference;
            if (cur == null) {
                if (location == null) {
                    DataFile head = null;
                    atomicReference = this.currentDataFile;
                    synchronized (atomicReference) {
                        head = this.dataFiles.getHead();
                    }
                    if (head == null) {
                        return null;
                    }
                    cur = new Location();
                    cur.setDataFileId(head.getDataFileId());
                    cur.setOffset(0);
                } else if (location.getSize() == -1) {
                    cur = new Location(location);
                } else {
                    cur = new Location(location);
                    cur.setOffset(location.getOffset() + location.getSize());
                }
            } else {
                cur.setOffset(cur.getOffset() + cur.getSize());
            }
            DataFile dataFile = this.getDataFile(cur);
            if (dataFile.getLength() <= cur.getOffset()) {
                atomicReference = this.currentDataFile;
                synchronized (atomicReference) {
                    dataFile = (DataFile)dataFile.getNext();
                }
                if (dataFile == null) {
                    return null;
                }
                cur.setDataFileId(dataFile.getDataFileId());
                cur.setOffset(0);
                if (limit != null && cur.compareTo(limit) >= 0) {
                    LOG.trace("reached limit: {} at: {}", (Object)limit, (Object)cur);
                    return null;
                }
            }
            DataFileAccessor reader = this.accessorPool.openDataFileAccessor(dataFile);
            try {
                reader.readLocationDetails(cur);
            }
            catch (EOFException eof) {
                LOG.trace("EOF on next: " + location + ", cur: " + cur);
                throw eof;
            }
            finally {
                this.accessorPool.closeDataFileAccessor(reader);
            }
            Sequence corruptedRange = dataFile.corruptedBlocks.get(cur.getOffset());
            if (corruptedRange != null) {
                cur.setSize((int)corruptedRange.range());
                continue;
            }
            if (cur.getSize() == EOF_INT && cur.getType() == 52 || cur.getType() == 0 && cur.getSize() == 0) {
                cur.setSize(EOF_RECORD.length);
                cur.setOffset(Math.max(this.maxFileLength, dataFile.getLength()));
                continue;
            }
            if (cur.getType() == 1) break;
        }
        return cur;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteSequence read(Location location) throws IOException, IllegalStateException {
        DataFile dataFile = this.getDataFile(location);
        DataFileAccessor reader = this.accessorPool.openDataFileAccessor(dataFile);
        ByteSequence rc = null;
        try {
            rc = reader.readRecord(location);
        }
        finally {
            this.accessorPool.closeDataFileAccessor(reader);
        }
        return rc;
    }

    public Location write(ByteSequence data, boolean sync) throws IOException, IllegalStateException {
        Location loc = this.appender.storeItem(data, (byte)1, sync);
        return loc;
    }

    public Location write(ByteSequence data, Runnable onComplete) throws IOException, IllegalStateException {
        Location loc = this.appender.storeItem(data, (byte)1, onComplete);
        return loc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Location location, ByteSequence data, boolean sync) throws IOException {
        DataFile dataFile = this.getDataFile(location);
        DataFileAccessor updater = this.accessorPool.openDataFileAccessor(dataFile);
        try {
            updater.updateRecord(location, data, sync);
        }
        finally {
            this.accessorPool.closeDataFileAccessor(updater);
        }
    }

    public PreallocationStrategy getPreallocationStrategy() {
        return this.preallocationStrategy;
    }

    public void setPreallocationStrategy(PreallocationStrategy preallocationStrategy) {
        this.preallocationStrategy = preallocationStrategy;
    }

    public PreallocationScope getPreallocationScope() {
        return this.preallocationScope;
    }

    public void setPreallocationScope(PreallocationScope preallocationScope) {
        this.preallocationScope = preallocationScope;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public String getFilePrefix() {
        return this.filePrefix;
    }

    public void setFilePrefix(String filePrefix) {
        this.filePrefix = filePrefix;
    }

    public Map<WriteKey, WriteCommand> getInflightWrites() {
        return this.inflightWrites;
    }

    public Location getLastAppendLocation() {
        return this.lastAppendLocation.get();
    }

    public void setLastAppendLocation(Location lastSyncedLocation) {
        this.lastAppendLocation.set(lastSyncedLocation);
    }

    public File getDirectoryArchive() {
        if (!this.directoryArchiveOverridden && this.directoryArchive == null) {
            this.directoryArchive = new File(this.directory.getAbsolutePath() + File.separator + DEFAULT_ARCHIVE_DIRECTORY);
        }
        return this.directoryArchive;
    }

    public void setDirectoryArchive(File directoryArchive) {
        this.directoryArchiveOverridden = true;
        this.directoryArchive = directoryArchive;
    }

    public boolean isArchiveDataLogs() {
        return this.archiveDataLogs;
    }

    public void setArchiveDataLogs(boolean archiveDataLogs) {
        this.archiveDataLogs = archiveDataLogs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataFile getDataFileById(int dataFileId) {
        AtomicReference<DataFile> atomicReference = this.currentDataFile;
        synchronized (atomicReference) {
            return this.fileMap.get(dataFileId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataFile getCurrentDataFile(int capacity) throws IOException {
        Object object = this.currentDataFile;
        synchronized (object) {
            if (this.currentDataFile.get().getLength() + capacity < this.maxFileLength) {
                return this.currentDataFile.get();
            }
        }
        object = this.dataFileIdLock;
        synchronized (object) {
            AtomicReference<DataFile> atomicReference = this.currentDataFile;
            synchronized (atomicReference) {
                if (this.currentDataFile.get().getLength() + capacity >= this.maxFileLength) {
                    this.rotateWriteFile();
                }
                return this.currentDataFile.get();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getCurrentDataFileId() {
        AtomicReference<DataFile> atomicReference = this.currentDataFile;
        synchronized (atomicReference) {
            return this.currentDataFile.get().getDataFileId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<File> getFiles() {
        AtomicReference<DataFile> atomicReference = this.currentDataFile;
        synchronized (atomicReference) {
            return this.fileByFileMap.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, DataFile> getFileMap() {
        AtomicReference<DataFile> atomicReference = this.currentDataFile;
        synchronized (atomicReference) {
            return new TreeMap<Integer, DataFile>(this.fileMap);
        }
    }

    public long getDiskSize() {
        return this.totalLength.get();
    }

    public void setReplicationTarget(ReplicationTarget replicationTarget) {
        this.replicationTarget = replicationTarget;
    }

    public ReplicationTarget getReplicationTarget() {
        return this.replicationTarget;
    }

    public String getFileSuffix() {
        return this.fileSuffix;
    }

    public void setFileSuffix(String fileSuffix) {
        this.fileSuffix = fileSuffix;
    }

    public boolean isChecksum() {
        return this.checksum;
    }

    public void setChecksum(boolean checksumWrites) {
        this.checksum = checksumWrites;
    }

    public boolean isCheckForCorruptionOnStartup() {
        return this.checkForCorruptionOnStartup;
    }

    public void setCheckForCorruptionOnStartup(boolean checkForCorruptionOnStartup) {
        this.checkForCorruptionOnStartup = checkForCorruptionOnStartup;
    }

    public void setWriteBatchSize(int writeBatchSize) {
        this.writeBatchSize = writeBatchSize;
    }

    public int getWriteBatchSize() {
        return this.writeBatchSize;
    }

    public void setSizeAccumulator(AtomicLong storeSizeAccumulator) {
        this.totalLength = storeSizeAccumulator;
    }

    public void setEnableAsyncDiskSync(boolean val) {
        this.enableAsyncDiskSync = val;
    }

    public boolean isEnableAsyncDiskSync() {
        return this.enableAsyncDiskSync;
    }

    public JournalDiskSyncStrategy getJournalDiskSyncStrategy() {
        return this.journalDiskSyncStrategy;
    }

    public void setJournalDiskSyncStrategy(JournalDiskSyncStrategy journalDiskSyncStrategy) {
        this.journalDiskSyncStrategy = journalDiskSyncStrategy;
    }

    public boolean isJournalDiskSyncPeriodic() {
        return JournalDiskSyncStrategy.PERIODIC.equals((Object)this.journalDiskSyncStrategy);
    }

    public void setDataFileRemovedListener(DataFileRemovedListener dataFileRemovedListener) {
        this.dataFileRemovedListener = dataFileRemovedListener;
    }

    public static class WriteKey {
        private final int file;
        private final long offset;
        private final int hash;

        public WriteKey(Location item) {
            this.file = item.getDataFileId();
            this.offset = item.getOffset();
            this.hash = (int)((long)this.file ^ this.offset);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj instanceof WriteKey) {
                WriteKey di = (WriteKey)obj;
                return di.file == this.file && di.offset == this.offset;
            }
            return false;
        }
    }

    public static class WriteCommand
    extends LinkedNode<WriteCommand> {
        public final Location location;
        public final ByteSequence data;
        final boolean sync;
        public final Runnable onComplete;

        public WriteCommand(Location location, ByteSequence data, boolean sync) {
            this.location = location;
            this.data = data;
            this.sync = sync;
            this.onComplete = null;
        }

        public WriteCommand(Location location, ByteSequence data, Runnable onComplete) {
            this.location = location;
            this.data = data;
            this.onComplete = onComplete;
            this.sync = false;
        }
    }

    public static interface DataFileRemovedListener {
        public void fileRemoved(DataFile var1);
    }

    public static enum JournalDiskSyncStrategy {
        ALWAYS,
        PERIODIC,
        NEVER;

    }

    public static enum PreallocationScope {
        ENTIRE_JOURNAL,
        ENTIRE_JOURNAL_ASYNC,
        NONE;

    }

    public static enum PreallocationStrategy {
        SPARSE_FILE,
        OS_KERNEL_COPY,
        ZEROS,
        CHUNKED_ZEROS;

    }
}

