/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store;

import org.apache.activemq.management.StatsImpl;
import org.apache.activemq.management.TimeStatisticImpl;

public class PersistenceAdapterStatistics
extends StatsImpl {
    protected TimeStatisticImpl slowCleanupTime = new TimeStatisticImpl("slowCleanupTime", "Slow time to cleanup data in the PersistentAdapter.");
    protected TimeStatisticImpl slowWriteTime = new TimeStatisticImpl("slowWriteTime", "Slow time to write data to the PersistentAdapter.");
    protected TimeStatisticImpl slowReadTime = new TimeStatisticImpl("slowReadTime", "Slow time to read data from the PersistentAdapter.");
    protected TimeStatisticImpl writeTime;
    protected TimeStatisticImpl readTime;

    public PersistenceAdapterStatistics() {
        this.addStatistic("slowCleanupTime", this.slowCleanupTime);
        this.addStatistic("slowWriteTime", this.slowWriteTime);
        this.addStatistic("slowReadTime", this.slowReadTime);
        this.writeTime = new TimeStatisticImpl("writeTime", "Time to write data to the PersistentAdapter.");
        this.readTime = new TimeStatisticImpl("readTime", "Time to read data from the PersistentAdapter.");
        this.addStatistic("writeTime", this.writeTime);
        this.addStatistic("readTime", this.readTime);
    }

    public void addSlowCleanupTime(long time) {
        this.slowCleanupTime.addTime(time);
    }

    public void addSlowWriteTime(long time) {
        this.slowWriteTime.addTime(time);
    }

    public void addSlowReadTime(long time) {
        this.slowReadTime.addTime(time);
    }

    public void addWriteTime(long time) {
        this.writeTime.addTime(time);
    }

    public void addReadTime(long time) {
        this.readTime.addTime(time);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.slowCleanupTime.setEnabled(enabled);
        this.slowWriteTime.setEnabled(enabled);
        this.slowReadTime.setEnabled(enabled);
        this.writeTime.setEnabled(enabled);
        this.readTime.setEnabled(enabled);
    }

    public TimeStatisticImpl getSlowCleanupTime() {
        return this.slowCleanupTime;
    }

    public TimeStatisticImpl getSlowWriteTime() {
        return this.slowWriteTime;
    }

    public TimeStatisticImpl getSlowReadTime() {
        return this.slowReadTime;
    }

    public TimeStatisticImpl getWriteTime() {
        return this.writeTime;
    }

    public TimeStatisticImpl getReadTime() {
        return this.readTime;
    }

    @Override
    public void reset() {
        if (this.isDoReset()) {
            this.writeTime.reset();
            this.readTime.reset();
            this.slowCleanupTime.reset();
            this.slowWriteTime.reset();
            this.slowReadTime.reset();
        }
    }

    public void setParent(PersistenceAdapterStatistics parent) {
        if (parent != null) {
            this.writeTime.setParent(parent.writeTime);
            this.readTime.setParent(parent.readTime);
            this.slowCleanupTime.setParent(parent.slowCleanupTime);
            this.slowWriteTime.setParent(parent.slowWriteTime);
            this.slowReadTime.setParent(parent.slowReadTime);
        } else {
            this.writeTime.setParent(null);
            this.readTime.setParent(null);
            this.slowCleanupTime.setParent(null);
            this.slowWriteTime.setParent(null);
            this.slowReadTime.setParent(null);
        }
    }
}

