/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.activemq.advisory.AdvisoryBroker;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.DurableTopicSubscription;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.TopicRegion;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.BrokerSubscriptionInfo;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.filter.DestinationFilter;
import org.apache.activemq.network.NetworkBridgeConfiguration;
import org.apache.activemq.util.SubscriptionKey;
import org.apache.activemq.util.TypeConversionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkBridgeUtils {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkBridgeUtils.class);

    public static BrokerSubscriptionInfo getBrokerSubscriptionInfo(BrokerService brokerService, NetworkBridgeConfiguration config) {
        RegionBroker regionBroker = (RegionBroker)brokerService.getRegionBroker();
        TopicRegion topicRegion = (TopicRegion)regionBroker.getTopicRegion();
        HashSet<ConsumerInfo> subscriptionInfos = new HashSet<ConsumerInfo>();
        for (Map.Entry<SubscriptionKey, DurableTopicSubscription> entry : topicRegion.getDurableSubscriptions().entrySet()) {
            SubscriptionKey key = entry.getKey();
            DurableTopicSubscription sub = entry.getValue();
            if (sub == null || !NetworkBridgeUtils.matchesConfigForDurableSync(config, key.getClientId(), key.getSubscriptionName(), sub.getActiveMQDestination())) continue;
            ConsumerInfo ci = sub.getConsumerInfo().copy();
            ci.setClientId(key.getClientId());
            subscriptionInfos.add(ci);
        }
        for (Subscription sub : topicRegion.getSubscriptions().values()) {
            if (sub == null || !NetworkBridgeUtils.isForcedDurable(sub.getConsumerInfo(), config.getDynamicallyIncludedDestinations())) continue;
            subscriptionInfos.add(sub.getConsumerInfo().copy());
        }
        try {
            AdvisoryBroker ab = (AdvisoryBroker)brokerService.getBroker().getAdaptor(AdvisoryBroker.class);
            if (ab != null && brokerService.isUseVirtualDestSubs() && config.isUseVirtualDestSubs()) {
                for (ConsumerInfo info : ab.getVirtualDestinationConsumers().keySet()) {
                    if (!NetworkBridgeUtils.isForcedDurable(info, config.getDynamicallyIncludedDestinations())) continue;
                    subscriptionInfos.add(info.copy());
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Error processing virtualDestinationSubs for BrokerSubscriptionInfo");
            LOG.debug("Error processing virtualDestinationSubs for BrokerSubscriptionInfo", (Throwable)e);
        }
        BrokerSubscriptionInfo bsi = new BrokerSubscriptionInfo(brokerService.getBrokerName());
        bsi.setSubscriptionInfos(subscriptionInfos.toArray(new ConsumerInfo[0]));
        return bsi;
    }

    public static boolean isForcedDurable(ConsumerInfo info, List<ActiveMQDestination> dynamicallyIncludedDestinations) {
        return dynamicallyIncludedDestinations != null && NetworkBridgeUtils.isForcedDurable(info, dynamicallyIncludedDestinations.toArray(new ActiveMQDestination[0]), null);
    }

    public static boolean isForcedDurable(ConsumerInfo info, ActiveMQDestination[] dynamicallyIncludedDestinations, ActiveMQDestination[] staticallyIncludedDestinations) {
        if (info.isDurable() || info.getDestination().isQueue()) {
            return false;
        }
        ActiveMQDestination destination = info.getDestination();
        if (AdvisorySupport.isAdvisoryTopic(destination) || destination.isTemporary() || destination.isQueue()) {
            return false;
        }
        ActiveMQDestination matching = NetworkBridgeUtils.findMatchingDestination(dynamicallyIncludedDestinations, destination);
        if (matching != null) {
            return NetworkBridgeUtils.isDestForcedDurable(matching);
        }
        matching = NetworkBridgeUtils.findMatchingDestination(staticallyIncludedDestinations, destination);
        if (matching != null) {
            return NetworkBridgeUtils.isDestForcedDurable(matching);
        }
        return false;
    }

    public static boolean matchesConfigForDurableSync(NetworkBridgeConfiguration config, String clientId, String subscriptionName, ActiveMQDestination destination) {
        if (config.getConsumerTTL() == 0) {
            return false;
        }
        if (NetworkBridgeUtils.isDirectBridgeConsumer(config, clientId, subscriptionName)) {
            return false;
        }
        if (config.getConsumerTTL() == 1 && NetworkBridgeUtils.isProxyBridgeSubscription(config, clientId, subscriptionName)) {
            return false;
        }
        return NetworkBridgeUtils.matchesDestinations(config.getDynamicallyIncludedDestinations(), destination);
    }

    public static boolean matchesDestination(ActiveMQDestination destFilter, ActiveMQDestination destToMatch) {
        DestinationFilter inclusionFilter = DestinationFilter.parseFilter(destFilter);
        return inclusionFilter.matches(destToMatch) && destFilter.getDestinationType() == destToMatch.getDestinationType();
    }

    public static boolean matchesDestinations(List<ActiveMQDestination> includedDests, ActiveMQDestination destination) {
        if (includedDests != null && !includedDests.isEmpty()) {
            for (ActiveMQDestination dest : includedDests) {
                if (!NetworkBridgeUtils.matchesDestination(dest, destination)) continue;
                return true;
            }
        }
        return false;
    }

    public static ActiveMQDestination findMatchingDestination(ActiveMQDestination[] dests, ActiveMQDestination destination) {
        if (dests != null) {
            for (ActiveMQDestination dest : dests) {
                if (!NetworkBridgeUtils.matchesDestination(dest, destination)) continue;
                return dest;
            }
        }
        return null;
    }

    public static boolean isDestForcedDurable(ActiveMQDestination destination) {
        Map<String, String> options;
        boolean isForceDurable = false;
        if (destination != null && (options = destination.getOptions()) != null) {
            isForceDurable = (Boolean)TypeConversionSupport.convert(options.get("forceDurable"), Boolean.TYPE);
        }
        return isForceDurable;
    }

    public static boolean isDirectBridgeConsumer(NetworkBridgeConfiguration config, String clientId, String subName) {
        return subName != null && subName.startsWith("NC-DS_") && (clientId == null || clientId.startsWith(config.getName()));
    }

    public static boolean isProxyBridgeSubscription(NetworkBridgeConfiguration config, String clientId, String subName) {
        if (subName != null && clientId != null) {
            return subName.startsWith("NC-DS_") && !clientId.startsWith(config.getName());
        }
        return false;
    }
}

