/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.sysinfo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.derby.iapi.tools.i18n.LocalizedOutput;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.impl.tools.sysinfo.ZipInfoProperties;
import org.apache.derby.shared.common.info.JVMInfo;
import org.apache.derby.shared.common.info.ProductVersionHolder;
import org.apache.derby.shared.common.reference.ModuleUtil;

public final class Main {
    private static final LocalizedResource LOCALIZED_RESOURCE = new LocalizedResource("org.apache.derby.loc.tools.sysinfoMessages");
    private static final String TEST_CLASS_NAME = "org.apache.derbyTesting.junit.XATestUtil";
    private static boolean setPause = false;
    private static boolean setLicense = false;
    private static boolean cptester = false;
    private static final String sep = "------------------------------------------------------";
    private static final String javaSep = Main.getTextMessage("SIF01.L", new Object[0]);
    private static final String jbmsSep = Main.getTextMessage("SIF01.M", new Object[0]);
    private static final String licSep = Main.getTextMessage("SIF01.N", new Object[0]);
    private static final String locSep = Main.getTextMessage("SIF01.P", new Object[0]);
    private static final String curLoc = Main.getTextMessage("SIF01.T", new Object[0]);
    private static final String EMBEDDED = "embedded";
    private static final String TOOLS = "tools";
    private static final String NET = "server";
    private static final String CLIENT = "client";
    private static final String MAINUSAGESTRING = "java org.apache.derby.tools.sysinfo -cp";
    private static final String USAGESTRINGPARTA = "java org.apache.derby.tools.sysinfo -cp [ [ embedded ][ server ][ client] [ tools ] [";
    private static final String USAGESTRINGPARTB = ".class ] ]";
    private static final String[] infoNames = new String[]{"org/apache/derby/info/engine/info.properties", "org/apache/derby/info/tools/info.properties", "org/apache/derby/info/net/info.properties", "org/apache/derby/info/client/info.properties", "org/apache/derby/info/shared/info.properties", "org/apache/derby/optional/info.properties"};
    private static final String[] jarNames = new String[]{"derby.jar", "derbyclient.jar", "derbynet.jar", "derbyoptionaltools.jar", "derbyrun.jar", "derbyshared.jar", "derbyTesting.jar", "derbytools.jar", "derbyLocale_cs.jar", "derbyLocale_de_DE.jar", "derbyLocale_es.jar", "derbyLocale_ja_JP.jar", "derbyLocale_ko_KR.jar", "derbyLocale_pl.jar", "derbyLocale_pt_BR.jar", "derbyLocale_ru.jar", "derbyLocale_fr.jar", "derbyLocale_zh_CN.jar", "derbyLocale_hu.jar", "derbyLocale_zh_TW.jar", "derbyLocale_it.jar"};

    public static void main(String[] stringArray) {
        LocalizedResource.getInstance().init();
        LocalizedOutput localizedOutput = LocalizedResource.OutputWriter();
        Main.parseArgs(stringArray);
        if (cptester) {
            Main.getClasspathInfo(stringArray, localizedOutput);
        } else {
            Main.getMainInfo(localizedOutput, setPause);
        }
    }

    public static void getMainInfo(PrintWriter printWriter, boolean bl) {
        printWriter.println(javaSep);
        Main.reportJavaInfo(printWriter);
        printWriter.println(jbmsSep);
        Main.reportDerby(printWriter);
        printWriter.println(sep);
        try {
            Main.reportLocales(printWriter);
        }
        catch (Exception exception) {
            printWriter.println(Main.getTextMessage("SIF01.Q", new Object[0]));
            printWriter.println(Main.getTextMessage("SIF01.B", new Object[0]));
        }
        try {
            Main.reportTesting(printWriter);
        }
        catch (Exception exception) {
            printWriter.println("Exception in reporting version of derbyTesting.jar");
            exception.printStackTrace();
        }
        if (bl) {
            Main.pause();
        }
    }

    private static void parseArgs(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-pause")) {
                setPause = true;
            }
            if (!stringArray[i].equals("-cp")) continue;
            cptester = true;
        }
    }

    private static void pause() {
        try {
            System.out.print(Main.getTextMessage("SIF01.C", new Object[0]));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            bufferedReader.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void reportDerby(PrintWriter printWriter) {
        String string = null;
        string = JVMInfo.isModuleAware() ? JVMInfo.getSystemModulePath() : System.getProperty("java.class.path");
        ZipInfoProperties[] zipInfoPropertiesArray = Main.getAllInfo(string);
        if (zipInfoPropertiesArray != null) {
            for (int i = 0; i < zipInfoPropertiesArray.length; ++i) {
                String string2 = "[" + zipInfoPropertiesArray[i].getLocation() + "] " + zipInfoPropertiesArray[i].getVersionBuildInfo();
                printWriter.println(string2);
            }
        } else {
            printWriter.println(Main.getTextMessage("SIF01.D", new Object[0]));
        }
    }

    private static void reportJavaInfo(PrintWriter printWriter) {
        printWriter.println(Main.getTextMessage("SIF02.A", Main.getJavaProperty("java.version")));
        printWriter.println(Main.getTextMessage("SIF02.B", Main.getJavaProperty("java.vendor")));
        printWriter.println(Main.getTextMessage("SIF02.C", Main.getJavaProperty("java.home")));
        printWriter.println(Main.getTextMessage("SIF02.D", Main.getJavaProperty("java.class.path")));
        printWriter.println(Main.getTextMessage("SIF02.E", Main.getJavaProperty("os.name")));
        printWriter.println(Main.getTextMessage("SIF02.F", Main.getJavaProperty("os.arch")));
        printWriter.println(Main.getTextMessage("SIF02.G", Main.getJavaProperty("os.version")));
        printWriter.println(Main.getTextMessage("SIF02.H", Main.getJavaProperty("user.name")));
        printWriter.println(Main.getTextMessage("SIF02.I", Main.getJavaProperty("user.home")));
        printWriter.println(Main.getTextMessage("SIF02.J", Main.getJavaProperty("user.dir")));
        printWriter.println("java.specification.name: " + Main.getJavaProperty("java.specification.name"));
        printWriter.println("java.specification.version: " + Main.getJavaProperty("java.specification.version"));
        Main.printPropertyIfNotNull(printWriter, "java.runtime.version");
        Main.printPropertyIfNotNull(printWriter, "java.fullversion");
    }

    private static void printPropertyIfNotNull(PrintWriter printWriter, String string) {
        String string2 = Main.getJavaProperty(string, true);
        if (string2 != null) {
            printWriter.println(string + ": " + string2);
        }
    }

    private static String getJavaProperty(String string) {
        return Main.getJavaProperty(string, false);
    }

    private static String getJavaProperty(String string, boolean bl) {
        String string2 = bl ? null : Main.getTextMessage("SIF01.H", new Object[0]);
        String string3 = System.getProperty(string, string2);
        return string3;
    }

    private static String getCanonicalPath(File file) throws IOException {
        return file.getCanonicalPath();
    }

    private static void getClasspathInfo(String[] stringArray, PrintWriter printWriter) {
        Main.useMe(stringArray, printWriter);
    }

    private static void reportLocales(PrintWriter printWriter) {
        boolean bl = true;
        printWriter.println(locSep);
        Locale[] localeArray = Locale.getAvailableLocales();
        Arrays.sort(localeArray, new LocaleSorter());
        Properties properties = new Properties();
        for (int i = 0; i < localeArray.length; ++i) {
            Locale locale = localeArray[i];
            String string = locale.toString();
            String string2 = "/org/apache/derby/info/locale_" + string + "/info.properties";
            Properties properties2 = properties;
            try {
                Object object;
                Object object2;
                Class<Main> clazz = Main.class;
                InputStream inputStream = null;
                if (JVMInfo.isModuleAware()) {
                    object2 = ModuleUtil.localizationModuleName(locale.toString());
                    object = ModuleUtil.derbyModule((String)object2);
                    if (object != null) {
                        inputStream = ((Module)object).getResourceAsStream(string2);
                    }
                } else {
                    inputStream = clazz.getResourceAsStream(string2);
                }
                object2 = inputStream;
                if (object2 == null) continue;
                try {
                    properties.clear();
                    properties.load((InputStream)object2);
                    if (bl) {
                        object = null;
                        object = Locale.getDefault();
                        printWriter.println(Main.getTextMessage("SIF01.T", new Object[0]) + "  [" + ((Locale)object).getDisplayLanguage() + "/" + ((Locale)object).getDisplayCountry() + " [" + (Locale)object + "]]");
                        bl = false;
                    }
                    object = properties.getProperty("derby.locale.external.name");
                    object = ((String)object).substring(((String)object).indexOf("[") + 1);
                    object = ((String)object).substring(0, ((String)object).indexOf("]"));
                    printWriter.println(Main.getTextMessage("SIF01.R", object));
                    int n = Integer.parseInt(properties.getProperty("derby.locale.version.major"));
                    int n2 = Integer.parseInt(properties.getProperty("derby.locale.version.minor"));
                    int n3 = Integer.parseInt(properties.getProperty("derby.locale.version.maint"));
                    String string3 = properties.getProperty("derby.locale.build.number");
                    String string4 = ProductVersionHolder.fullVersionString(n, n2, n3, false, string3);
                    printWriter.println(Main.getTextMessage("SIF01.S", string4));
                }
                catch (IOException iOException) {
                    printWriter.println("Could not get locale properties from : " + (InputStream)object2);
                }
                continue;
            }
            catch (Throwable throwable) {
                printWriter.println("Could not load resource: " + string2);
                printWriter.println("Exception: " + throwable);
            }
        }
        printWriter.println(sep);
    }

    private static void reportTesting(PrintWriter printWriter) {
        String string = "org.apache.derbyTesting.*:";
        Properties properties = new Properties();
        String string2 = "/org/apache/derby/info/tsting/info.properties";
        Properties properties2 = properties;
        String string3 = string2;
        try {
            Object object;
            Object object2;
            Class<Main> clazz = Main.class;
            InputStream inputStream = null;
            if (JVMInfo.isModuleAware()) {
                object2 = "org.apache.derby.tests";
                object = ModuleUtil.derbyModule((String)object2);
                if (object != null) {
                    inputStream = ((Module)object).getResourceAsStream(string3);
                }
            } else {
                inputStream = clazz.getResourceAsStream(string3);
            }
            if (inputStream != null) {
                try {
                    properties.clear();
                    properties.load(inputStream);
                    object2 = null;
                    if (JVMInfo.isModuleAware()) {
                        try {
                            object = ModuleUtil.derbyModule("org.apache.derby.tests");
                            var10_14 = ((Module)object).getClassLoader().loadClass(TEST_CLASS_NAME);
                            object2 = var10_14.getProtectionDomain().getCodeSource().getLocation();
                        }
                        catch (Exception exception) {}
                    } else {
                        object = new StringBuffer(Main.getTextMessage(Main.crLf(), new Object[0]));
                        var10_14 = new StringBuffer(Main.crLf() + Main.getTextMessage("SIF08.E", new Object[0]) + Main.crLf());
                        Main.tryTstingClasspath((StringBuffer)object, var10_14);
                        String string4 = ((StringBuffer)object).toString();
                        if (string4.isEmpty() || string4.length() <= 2) {
                            return;
                        }
                        object2 = new URL(string4);
                    }
                    if (object2 == null) {
                        return;
                    }
                    printWriter.println(string);
                    printWriter.print("\t ");
                    printWriter.print("[");
                    printWriter.print(Main.formatURL((URL)object2));
                    printWriter.println("]");
                    int n = Integer.parseInt(properties.getProperty("derby.tsting.version.major"));
                    int n2 = Integer.parseInt(properties.getProperty("derby.tsting.version.minor"));
                    int n3 = Integer.parseInt(properties.getProperty("derby.tsting.version.maint"));
                    String string5 = properties.getProperty("derby.tsting.build.number");
                    String string6 = ProductVersionHolder.fullVersionString(n, n2, n3, false, string5);
                    printWriter.println(Main.getTextMessage("SIF01.S", string6));
                }
                catch (IOException iOException) {
                    printWriter.println("Could not get testing properties from : " + inputStream);
                }
            }
            printWriter.println(sep);
        }
        catch (Throwable throwable) {
            printWriter.println("Could not load resource: " + string2);
            printWriter.println("Exception: " + throwable);
        }
    }

    static void useMe(String[] stringArray, PrintWriter printWriter) {
        int n;
        PrintWriter printWriter2 = printWriter;
        if (printWriter2 == null) {
            printWriter2 = new PrintWriter(System.out);
        }
        if ((n = stringArray.length) == 1) {
            try {
                Main.tryAllClasspaths(printWriter2);
            }
            catch (Throwable throwable) {}
        } else {
            try {
                Main.trySomeClasspaths(stringArray, printWriter2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void tryAllClasspaths(PrintWriter printWriter) throws Throwable {
        printWriter.println(Main.getTextMessage("SIF08.B", new Object[0]));
        printWriter.println(Main.getTextMessage("SIF08.C", "java org.apache.derby.tools.sysinfo -cp args"));
        StringBuffer stringBuffer = new StringBuffer(Main.getTextMessage("SIF08.D", new Object[0]) + Main.crLf());
        StringBuffer stringBuffer2 = new StringBuffer(Main.crLf() + Main.getTextMessage("SIF08.E", new Object[0]) + Main.crLf());
        Main.tryCoreClasspath(stringBuffer, stringBuffer2);
        Main.tryNetClasspath(stringBuffer, stringBuffer2);
        Main.tryClientClasspath(stringBuffer, stringBuffer2);
        Main.tryUtilsClasspath(stringBuffer, stringBuffer2);
        printWriter.println(stringBuffer.toString());
        if (!stringBuffer2.toString().equals(Main.crLf() + Main.getTextMessage("SIF08.E", new Object[0]) + Main.crLf())) {
            printWriter.println(stringBuffer2.toString());
        } else {
            printWriter.println(Main.getTextMessage("SIF08.F", new Object[0]));
        }
        printWriter.flush();
    }

    private static void trySomeClasspaths(String[] stringArray, PrintWriter printWriter) throws Throwable {
        String string;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(Main.getTextMessage("SIF08.D", new Object[0]) + Main.crLf());
        StringBuffer stringBuffer2 = new StringBuffer(Main.crLf() + Main.getTextMessage("SIF08.E", new Object[0]) + Main.crLf());
        if (Main.argumentsContain(stringArray, EMBEDDED)) {
            Main.tryCoreClasspath(stringBuffer, stringBuffer2);
            bl = true;
        }
        if (Main.argumentsContain(stringArray, NET)) {
            Main.tryNetClasspath(stringBuffer, stringBuffer2);
            bl = true;
        }
        if (Main.argumentsContain(stringArray, CLIENT)) {
            Main.tryClientClasspath(stringBuffer, stringBuffer2);
            bl = true;
        }
        if (Main.argumentsContain(stringArray, TOOLS) || Main.argumentsContain(stringArray, "utils")) {
            Main.tryUtilsClasspath(stringBuffer, stringBuffer2);
            bl = true;
        }
        if (!(string = Main.argumentMatches(stringArray, ".class")).equals("")) {
            Main.tryMyClasspath(Main.argumentMatches(stringArray, ".class"), Main.getTextMessage("SIF08.H", string), stringBuffer, stringBuffer2);
            bl = true;
        }
        if (bl) {
            printWriter.println(stringBuffer.toString());
            if (!stringBuffer2.toString().equals(Main.crLf() + Main.getTextMessage("SIF08.E", new Object[0]) + Main.crLf())) {
                printWriter.println(stringBuffer2.toString());
            } else {
                printWriter.println(Main.getTextMessage("SIF08.F", new Object[0]));
            }
        } else {
            printWriter.println(Main.getTextMessage("SIF08.A", USAGESTRINGPARTA, USAGESTRINGPARTB));
        }
        printWriter.flush();
    }

    private static void tryCoreClasspath(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        Main.tryMyClasspath("org.apache.derby.database.Database", Main.getTextMessage("SIF08.J", "derby.jar"), stringBuffer, stringBuffer2);
    }

    private static void tryNetClasspath(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        Main.tryMyClasspath("org.apache.derby.database.Database", Main.getTextMessage("SIF08.J", "derby.jar"), stringBuffer, stringBuffer2);
        Main.tryMyClasspath("org.apache.derby.drda.NetworkServerControl", Main.getTextMessage("SIF08.I", "derbynet.jar"), stringBuffer, stringBuffer2);
    }

    private static void tryClientClasspath(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        Main.tryMyClasspath("org.apache.derby.jdbc.ClientDriver", Main.getTextMessage("SIF08.L", "derbyclient.jar"), stringBuffer, stringBuffer2);
    }

    private static void tryUtilsClasspath(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        Main.tryMyClasspath("org.apache.derby.tools.ij", Main.getTextMessage("SIF08.Q", "derbytools.jar"), stringBuffer, stringBuffer2);
    }

    private static void tryTstingClasspath(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        Main.tryMyClasspath(TEST_CLASS_NAME, "", stringBuffer, stringBuffer2);
    }

    private static void tryMyClasspath(String string, String string2, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        try {
            Class<?> clazz = Class.forName(string);
            String string3 = Main.getFileWhichLoadedClass(clazz);
            stringBuffer.append(Main.found(string, string2, string3));
        }
        catch (Throwable throwable) {
            stringBuffer2.append(Main.notFound(string, string2));
        }
    }

    private static void tryAsResource(String string, String string2, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        try {
            InputStream inputStream = string.getClass().getResourceAsStream(string);
            inputStream.close();
            String string3 = Main.getFileWhichLoadedClass(string.getClass());
            stringBuffer.append(Main.found(string, string2, string3));
        }
        catch (Throwable throwable) {
            stringBuffer2.append(Main.notFound(string, string2));
        }
    }

    private static String found(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(Main.crLf());
        stringBuffer.append("   " + string2);
        stringBuffer.append(Main.crLf());
        if (string3 != null) {
            stringBuffer.append("   ").append(string3).append(Main.crLf());
        }
        stringBuffer.append(Main.crLf());
        return stringBuffer.toString();
    }

    private static String notFound(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(Main.crLf());
        stringBuffer.append("   " + string2);
        stringBuffer.append(Main.crLf());
        stringBuffer.append("    " + Main.getTextMessage("SIF08.U", string));
        stringBuffer.append(Main.crLf());
        stringBuffer.append(Main.crLf());
        return stringBuffer.toString();
    }

    private static String crLf() {
        return System.getProperty("line.separator");
    }

    private static String lookForMainArg(String[] stringArray, PrintWriter printWriter) {
        int n = stringArray.length;
        String[] stringArray2 = new String[]{EMBEDDED};
        int n2 = 0;
        String string = "";
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < stringArray2.length; ++j) {
                if (!stringArray[i].toUpperCase(Locale.ENGLISH).equals(stringArray2[j].toUpperCase(Locale.ENGLISH))) continue;
                ++n2;
                string = stringArray2[j];
            }
        }
        if (n2 > 1 || n2 < 1) {
            printWriter.println(Main.getTextMessage("SIF08.A", USAGESTRINGPARTA, USAGESTRINGPARTB));
            return "";
        }
        return string;
    }

    private static boolean argumentsContain(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private static String argumentMatches(String[] stringArray, String string) {
        String string2 = "";
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].endsWith(string)) continue;
            string2 = stringArray[i].substring(0, stringArray[i].length() - 6);
        }
        return string2;
    }

    public static ZipInfoProperties[] getAllInfo(String string) {
        Object object;
        ZipInfoProperties[] zipInfoPropertiesArray = Main.loadZipFromResource();
        if (zipInfoPropertiesArray == null) {
            zipInfoPropertiesArray = new ZipInfoProperties[1];
            object = new ZipInfoProperties(ProductVersionHolder.getProductVersionHolderFromMyEnv(TOOLS));
            ((ZipInfoProperties)object).setLocation(Main.getFileWhichLoadedClass(new Main().getClass()));
            zipInfoPropertiesArray[0] = object;
        }
        if (string != null) {
            object = Main.parseClasspath(string);
            List<String> list = Arrays.asList(jarNames);
            Vector<String[]> vector = new Vector<String[]>();
            for (int i = 0; i < ((Object)object).length; ++i) {
                boolean bl = false;
                Object object2 = object[i];
                Object object3 = jarNames;
                int n = ((String[])object3).length;
                for (int j = 0; j < n; ++j) {
                    String string2 = object3[j];
                    if (!((String)object2).endsWith(string2)) continue;
                    bl = true;
                    break;
                }
                if (!bl || (object3 = Main.checkForInfo((String)object[i])) == null) continue;
                vector.addElement((String[])object3);
            }
            if (vector.size() > 0) {
                Object[] objectArray = new ZipInfoProperties[vector.size()];
                vector.copyInto(objectArray);
                return Main.mergeZips(zipInfoPropertiesArray, (ZipInfoProperties[])objectArray);
            }
        }
        return Main.mergeZips(zipInfoPropertiesArray, null);
    }

    private static ZipInfoProperties[] loadZipFromResource() {
        ArrayList<ZipInfoProperties> arrayList = new ArrayList<ZipInfoProperties>();
        for (int i = 0; i < infoNames.length; ++i) {
            String string = "/".concat(infoNames[i]);
            InputStream inputStream = new Main().getClass().getResourceAsStream(string);
            if (inputStream == null) continue;
            ZipInfoProperties zipInfoProperties = new ZipInfoProperties(ProductVersionHolder.getProductVersionHolderFromMyEnv(inputStream));
            URL uRL = new Main().getClass().getResource(string);
            zipInfoProperties.setLocation(Main.formatURL(uRL));
            arrayList.add(zipInfoProperties);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        ZipInfoProperties[] zipInfoPropertiesArray = new ZipInfoProperties[arrayList.size()];
        arrayList.toArray(zipInfoPropertiesArray);
        return zipInfoPropertiesArray;
    }

    private static String[] parseClasspath(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        int n = stringTokenizer.countTokens();
        if (n == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    private static ZipInfoProperties checkForInfo(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return null;
        }
        if (file.isDirectory()) {
            ZipInfoProperties zipInfoProperties = Main.checkDirectory(string);
            return zipInfoProperties;
        }
        if (file.isFile()) {
            ZipInfoProperties zipInfoProperties = Main.checkFile(string);
            return zipInfoProperties;
        }
        return null;
    }

    private static ZipInfoProperties checkDirectory(String string) {
        Object object;
        boolean bl = false;
        File file = null;
        for (int i = 0; i < infoNames.length; ++i) {
            object = infoNames[i].replace('/', File.separatorChar);
            file = new File(string, (String)object);
            if (!file.exists()) continue;
            bl = true;
            break;
        }
        if (!bl || file == null) {
            return null;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            object = new ZipInfoProperties(ProductVersionHolder.getProductVersionHolderFromMyEnv(fileInputStream));
            ((ZipInfoProperties)object).setLocation(Main.getCanonicalPath(new File(string)).replace('/', File.separatorChar));
            return object;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static ZipInfoProperties checkFile(String string) {
        try {
            ZipFile zipFile = new ZipFile(string);
            ZipEntry zipEntry = null;
            for (int i = 0; i < infoNames.length && (zipEntry = zipFile.getEntry(infoNames[i])) == null; ++i) {
            }
            if (zipEntry == null) {
                return null;
            }
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            if (inputStream == null) {
                return null;
            }
            ZipInfoProperties zipInfoProperties = new ZipInfoProperties(ProductVersionHolder.getProductVersionHolderFromMyEnv(inputStream));
            zipInfoProperties.setLocation(Main.getCanonicalPath(new File(string)).replace('/', File.separatorChar));
            return zipInfoProperties;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String getTextMessage(String string, Object ... objectArray) {
        return LOCALIZED_RESOURCE.getTextMessage(string, objectArray);
    }

    private static String getFileWhichLoadedClass(Class clazz) {
        CodeSource codeSource = null;
        codeSource = clazz.getProtectionDomain().getCodeSource();
        if (codeSource == null) {
            return null;
        }
        URL uRL = codeSource.getLocation();
        try {
            return URLDecoder.decode(uRL.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return unsupportedEncodingException.getMessage();
        }
    }

    private static ZipInfoProperties[] mergeZips(ZipInfoProperties[] zipInfoPropertiesArray, ZipInfoProperties[] zipInfoPropertiesArray2) {
        int n;
        int n2;
        Vector<ZipInfoProperties> vector = new Vector<ZipInfoProperties>();
        boolean bl = false;
        for (n2 = 0; n2 < zipInfoPropertiesArray.length; ++n2) {
            if (zipInfoPropertiesArray[n2] != null && zipInfoPropertiesArray.length > 1) {
                for (n = n2 + 1; n < zipInfoPropertiesArray.length; ++n) {
                    if (!zipInfoPropertiesArray[n2].getLocation().equals(zipInfoPropertiesArray[n].getLocation())) continue;
                    zipInfoPropertiesArray[n] = null;
                }
            }
            if (zipInfoPropertiesArray[n2] == null) continue;
            vector.addElement(zipInfoPropertiesArray[n2]);
        }
        if (zipInfoPropertiesArray2 != null) {
            for (n2 = 0; n2 < zipInfoPropertiesArray2.length; ++n2) {
                for (n = 0; n < vector.size(); ++n) {
                    ZipInfoProperties zipInfoProperties = (ZipInfoProperties)vector.get(n);
                    if (!zipInfoPropertiesArray2[n2].getLocation().equals(zipInfoProperties.getLocation())) continue;
                    bl = true;
                }
                if (!bl) {
                    vector.addElement(zipInfoPropertiesArray2[n2]);
                }
                bl = false;
            }
        }
        Object[] objectArray = new ZipInfoProperties[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static String formatURL(URL uRL) {
        String string;
        try {
            string = URLDecoder.decode(uRL.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        if (string.startsWith("jar:")) {
            string = string.substring(4);
        }
        if (string.startsWith("file:")) {
            string = string.substring(5);
        }
        if (string.indexOf("!") > -1) {
            string = string.substring(0, string.indexOf("!"));
        }
        if (string.indexOf("/org/apache/derby") > -1) {
            string = string.substring(0, string.indexOf("/org/apache/derby"));
        }
        if (string.charAt(0) == '/' && Character.isLetter(string.charAt(1)) && string.charAt(2) == ':' && string.charAt(2) == '/') {
            string = string.substring(1);
        }
        String string2 = "";
        try {
            string2 = Main.getCanonicalPath(new File(string)).replace('/', File.separatorChar);
        }
        catch (IOException iOException) {
            string2 = iOException.getMessage();
        }
        return string2;
    }

    public static class LocaleSorter
    implements Comparator<Locale> {
        @Override
        public int compare(Locale locale, Locale locale2) {
            return locale.toString().compareTo(locale2.toString());
        }
    }
}

