/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLDate;
import org.apache.derby.iapi.types.SQLTime;
import org.apache.derby.iapi.types.SQLTimestamp;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;

class UserTypeConstantNode
extends ConstantNode {
    Object val;

    UserTypeConstantNode(TypeId typeId, ContextManager contextManager) throws StandardException {
        super(typeId, true, -1, contextManager);
    }

    UserTypeConstantNode(Date date, ContextManager contextManager) throws StandardException {
        super(TypeId.getBuiltInTypeId(91), date == null, 10, contextManager);
        this.setValue(new SQLDate(date));
        this.val = date;
    }

    UserTypeConstantNode(Time time, ContextManager contextManager) throws StandardException {
        super(TypeId.getBuiltInTypeId(92), time == null, 8, contextManager);
        this.setValue(new SQLTime(time));
        this.val = time;
    }

    UserTypeConstantNode(Timestamp timestamp, ContextManager contextManager) throws StandardException {
        super(TypeId.getBuiltInTypeId(93), timestamp == null, 29, contextManager);
        this.setValue(new SQLTimestamp(timestamp));
        this.val = timestamp;
    }

    UserTypeConstantNode(DataValueDescriptor dataValueDescriptor, ContextManager contextManager) throws StandardException {
        super(UserTypeConstantNode.getTypeId(dataValueDescriptor), dataValueDescriptor == null, UserTypeConstantNode.getWidth(dataValueDescriptor), contextManager);
        this.setValue(dataValueDescriptor);
        this.val = dataValueDescriptor;
    }

    private static TypeId getTypeId(DataValueDescriptor dataValueDescriptor) {
        if (dataValueDescriptor != null) {
            switch (dataValueDescriptor.getTypeFormatId()) {
                case 298: {
                    return TypeId.getBuiltInTypeId(91);
                }
                case 299: {
                    return TypeId.getBuiltInTypeId(92);
                }
                case 31: {
                    return TypeId.getBuiltInTypeId(93);
                }
            }
            return null;
        }
        return null;
    }

    private static int getWidth(DataValueDescriptor dataValueDescriptor) {
        if (dataValueDescriptor != null) {
            switch (dataValueDescriptor.getTypeFormatId()) {
                case 298: {
                    return 10;
                }
                case 299: {
                    return 8;
                }
                case 31: {
                    return 29;
                }
            }
            return 0;
        }
        return 0;
    }

    public Object getObjectValue() {
        return this.val;
    }

    @Override
    boolean isNull() {
        return this.val == null;
    }

    @Override
    Object getConstantValueAsObject() {
        return this.val;
    }

    @Override
    void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        TypeCompiler typeCompiler = this.getTypeCompiler();
        String string = typeCompiler.interfaceName();
        if (this.val == null) {
            expressionClassBuilder.generateNull(methodBuilder, typeCompiler, this.getTypeServices().getCollationType());
        } else {
            String string2 = this.getTypeId().getCorrespondingJavaTypeName();
            methodBuilder.push(this.val.toString());
            methodBuilder.callMethod((short)184, string2, "valueOf", string2, 1);
            LocalField localField = expressionClassBuilder.newFieldDeclaration(2, string);
            expressionClassBuilder.generateDataValue(methodBuilder, typeCompiler, this.getTypeServices().getCollationType(), localField);
        }
    }

    @Override
    void generateConstant(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
    }
}

