/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.soap.extension;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.soap.SoapServiceProvider;
import org.mule.runtime.extension.api.soap.WebServiceDefinition;
import org.mule.runtime.extension.api.soap.annotation.Soap;
import org.mule.test.soap.extension.CalcioServiceProvider;
import org.mule.test.soap.extension.LaLigaServiceProvider;

@Alias(value="base")
@Soap(value={LaLigaServiceProvider.class, CalcioServiceProvider.class})
@Extension(name="soap", description="Soap Connect Test Extension")
public class FootballSoapExtension
implements SoapServiceProvider {
    public static final String LEAGUES_ID = "leagues";
    public static final String LEAGUES_FRIENDLY_NAME = "Football Leagues";
    public static final String LEAGUES_SERVICE = "LeaguesService";
    public static final String LEAGUES_PORT = "LeaguesPort";
    public static final String TEST_SERVICE_URL = "http://some-url.com";
    @Parameter
    @Optional(defaultValue="http://some-url.com")
    private String leaguesAddress;
    @Parameter
    private String laLigaAddress;

    public List<WebServiceDefinition> getWebServiceDefinitions() {
        return Arrays.asList(this.getLeaguesService(), this.getLaLigaService());
    }

    private WebServiceDefinition getLaLigaService() {
        return new LaLigaServiceProvider(this.laLigaAddress).getFirstDivisionService();
    }

    private WebServiceDefinition getLeaguesService() {
        return WebServiceDefinition.builder().withId(LEAGUES_ID).withFriendlyName(LEAGUES_FRIENDLY_NAME).withWsdlUrl(this.leaguesAddress + "?wsdl").withAddress(this.leaguesAddress).withService(LEAGUES_SERVICE).withPort(LEAGUES_PORT).withExcludedOperations(Collections.emptyList()).build();
    }
}

