/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.heisenberg.extension;

import java.math.BigDecimal;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Attributes;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.scheduler.SchedulerService;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.execution.OnError;
import org.mule.runtime.extension.api.annotation.execution.OnSuccess;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.UseConfig;
import org.mule.runtime.extension.api.annotation.source.EmitsResponse;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.test.heisenberg.extension.HeisenbergConnection;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.heisenberg.extension.RicinGroup;
import org.mule.test.heisenberg.extension.model.Methylamine;

@Alias(value="ListenPayments")
@EmitsResponse
public class HeisenbergSource
extends Source<String, Attributes> {
    public static final String CORE_POOL_SIZE_ERROR_MESSAGE = "corePoolSize cannot be a negative value";
    public static final String INITIAL_BATCH_NUMBER_ERROR_MESSAGE = "initialBatchNumber cannot be a negative value";
    @Inject
    private SchedulerService schedulerService;
    private Scheduler executor;
    @UseConfig
    private HeisenbergExtension heisenberg;
    @Connection
    private HeisenbergConnection connection;
    @Parameter
    private volatile int initialBatchNumber;
    @Parameter
    @Optional(defaultValue="1")
    private int corePoolSize;

    public void onStart(SourceCallback<String, Attributes> sourceCallback) throws MuleException {
        Preconditions.checkArgument((this.heisenberg != null ? 1 : 0) != 0, (String)"config not injected");
        this.connection.verifyLifecycle(1, 1, 0, 0);
        ++HeisenbergExtension.sourceTimesStarted;
        if (this.corePoolSize < 0) {
            throw new RuntimeException(CORE_POOL_SIZE_ERROR_MESSAGE);
        }
        this.executor = this.schedulerService.cpuLightScheduler();
        this.executor.scheduleAtFixedRate(() -> sourceCallback.handle(this.makeResult(sourceCallback)), 0L, 100L, TimeUnit.MILLISECONDS);
    }

    @OnSuccess
    public void onResponse(@Optional(defaultValue="#[payload]") Long payment, @Optional String sameNameParameter, @ParameterGroup(name="Dangerous-Ricin") RicinGroup ricin) {
        this.heisenberg.setMoney(this.heisenberg.getMoney().add(BigDecimal.valueOf(payment)));
    }

    @OnError
    public void onError(Error error, @Optional String sameNameParameter, @Optional Methylamine methylamine) {
        this.heisenberg.setMoney(BigDecimal.valueOf(-1L));
    }

    public void onStop() {
        if (this.executor != null) {
            this.executor.shutdown();
            try {
                this.executor.awaitTermination(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Result<String, Attributes> makeResult(SourceCallback sourceCallback) {
        if (this.initialBatchNumber < 0) {
            sourceCallback.onSourceException((Throwable)new RuntimeException(INITIAL_BATCH_NUMBER_ERROR_MESSAGE));
        }
        return Result.builder().output((Object)String.format("Meth Batch %d. If found by DEA contact %s", ++this.initialBatchNumber, this.connection.getSaulPhoneNumber())).build();
    }
}

