/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.heisenberg.extension;

import java.util.Optional;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Attributes;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.scheduler.SchedulerService;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Streaming;
import org.mule.runtime.extension.api.annotation.execution.OnError;
import org.mule.runtime.extension.api.annotation.execution.OnSuccess;
import org.mule.runtime.extension.api.annotation.execution.OnTerminate;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.source.EmitsResponse;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceResult;
import org.mule.test.heisenberg.extension.HeisenbergConnection;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.heisenberg.extension.RicinGroup;
import org.mule.test.heisenberg.extension.model.Methylamine;
import org.mule.test.heisenberg.extension.model.PersonalInfo;

@Alias(value="ListenPayments")
@EmitsResponse
@Streaming
public class HeisenbergSource
extends Source<String, Attributes> {
    public static final String CORE_POOL_SIZE_ERROR_MESSAGE = "corePoolSize cannot be a negative value";
    public static final String INITIAL_BATCH_NUMBER_ERROR_MESSAGE = "initialBatchNumber cannot be a negative value";
    @Inject
    private SchedulerService schedulerService;
    private Scheduler executor;
    private ScheduledFuture<?> scheduledFuture;
    @Config
    private HeisenbergExtension heisenberg;
    @Connection
    private HeisenbergConnection connection;
    @Parameter
    private volatile int initialBatchNumber;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="1")
    private int corePoolSize;
    public static boolean receivedGroupOnSource;
    public static boolean receivedInlineOnSuccess;
    public static boolean receivedInlineOnError;
    public static TerminateStatus terminateStatus;
    public static Optional<Error> error;
    public static boolean executedOnSuccess;
    public static boolean executedOnError;
    public static boolean executedOnTerminate;
    public static long gatheredMoney;

    public HeisenbergSource() {
        receivedGroupOnSource = false;
        receivedInlineOnSuccess = false;
        receivedInlineOnError = false;
        terminateStatus = TerminateStatus.NONE;
        executedOnSuccess = false;
        executedOnError = false;
        executedOnTerminate = false;
        gatheredMoney = 0L;
    }

    public void onStart(SourceCallback<String, Attributes> sourceCallback) throws MuleException {
        Preconditions.checkArgument((this.heisenberg != null ? 1 : 0) != 0, (String)"config not injected");
        this.connection.verifyLifecycle(1, 1, 0, 0);
        ++HeisenbergExtension.sourceTimesStarted;
        if (this.corePoolSize < 0) {
            throw new RuntimeException(CORE_POOL_SIZE_ERROR_MESSAGE);
        }
        this.executor = this.schedulerService.cpuLightScheduler();
        this.scheduledFuture = this.executor.scheduleAtFixedRate(() -> sourceCallback.handle(this.makeResult(sourceCallback)), 0L, 300L, TimeUnit.MILLISECONDS);
    }

    @OnSuccess
    public void onSuccess(@org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="#[payload]") Long payment, @org.mule.runtime.extension.api.annotation.param.Optional String sameNameParameter, @ParameterGroup(name="Dangerous-Ricin") RicinGroup ricin, @ParameterGroup(name="Success Info", showInDsl=true) PersonalInfo successInfo, @org.mule.runtime.extension.api.annotation.param.Optional boolean fail) {
        gatheredMoney += payment.longValue();
        receivedGroupOnSource = ricin != null && ricin.getNextDoor().getAddress() != null;
        receivedInlineOnSuccess = successInfo != null && successInfo.getAge() != null && successInfo.getKnownAddresses() != null;
        executedOnSuccess = true;
        if (fail) {
            throw new RuntimeException("Some internal exception");
        }
    }

    @OnError
    public void onError(Error error, @org.mule.runtime.extension.api.annotation.param.Optional String sameNameParameter, @org.mule.runtime.extension.api.annotation.param.Optional Methylamine methylamine, @ParameterGroup(name="Dangerous-Ricin") RicinGroup ricin, @ParameterGroup(name="Error Info", showInDsl=true) PersonalInfo infoError, @org.mule.runtime.extension.api.annotation.param.Optional boolean propagateError) {
        gatheredMoney = -1L;
        receivedGroupOnSource = ricin != null && ricin.getNextDoor() != null && ricin.getNextDoor().getAddress() != null;
        receivedInlineOnError = infoError != null && infoError.getName() != null && !infoError.getName().equals("Heisenberg");
        executedOnError = true;
        if (propagateError) {
            throw new RuntimeException("Some internal exception");
        }
    }

    @OnTerminate
    public void onTerminate(SourceResult sourceResult) {
        if (sourceResult.isSuccess()) {
            terminateStatus = TerminateStatus.SUCCESS;
        } else {
            sourceResult.getInvocationError().ifPresent(parameterError -> {
                terminateStatus = TerminateStatus.ERROR_INVOKE;
                error = Optional.of(parameterError);
            });
            sourceResult.getResponseError().ifPresent(bodyError -> {
                terminateStatus = TerminateStatus.ERROR_BODY;
                error = Optional.of(bodyError);
            });
        }
        executedOnTerminate = true;
    }

    public void onStop() {
        if (this.executor != null) {
            this.scheduledFuture.cancel(true);
            this.executor.stop();
        }
        receivedGroupOnSource = false;
        gatheredMoney = 0L;
    }

    private Result<String, Attributes> makeResult(SourceCallback sourceCallback) {
        if (this.initialBatchNumber < 0) {
            sourceCallback.onSourceException((Throwable)new RuntimeException(INITIAL_BATCH_NUMBER_ERROR_MESSAGE));
        }
        return Result.builder().output((Object)String.format("Meth Batch %d. If found by DEA contact %s", ++this.initialBatchNumber, this.connection.getSaulPhoneNumber())).build();
    }

    public static enum TerminateStatus {
        SUCCESS,
        ERROR_INVOKE,
        ERROR_BODY,
        NONE;

    }
}

