/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.heisenberg.extension;

import java.util.List;
import java.util.stream.Collectors;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.stereotype.Stereotype;
import org.mule.test.heisenberg.extension.model.KillParameters;
import org.mule.test.heisenberg.extension.model.Ricin;
import org.mule.test.heisenberg.extension.model.Weapon;
import org.mule.test.heisenberg.extension.model.types.WeaponType;
import org.mule.test.heisenberg.extension.stereotypes.DrugKillingStereotype;
import org.mule.test.heisenberg.extension.stereotypes.KillingStereotype;

@Stereotype(value=KillingStereotype.class)
public class KillingOperations {
    public String killWithCustomMessage(@ParameterGroup(name="KillGroup") KillParameters killParameters) {
        return String.format("%s, %s", killParameters.getGoodbyeMessage(), killParameters.getVictim());
    }

    public String killWithWeapon(Weapon weapon, WeaponType type, Weapon.WeaponAttributes attributesOfWeapon) {
        return String.format("Killed with: %s , Type %s and attribute %s", weapon.kill(), type.name(), attributesOfWeapon.getBrand());
    }

    public List<String> killWithMultiplesWeapons(@Optional(defaultValue="#[payload]") List<Weapon> weapons) {
        return weapons.stream().map(Weapon::kill).collect(Collectors.toList());
    }

    public List<String> killWithMultipleWildCardWeapons(List<? extends Weapon> wildCardWeapons) {
        return wildCardWeapons.stream().map(Weapon::kill).collect(Collectors.toList());
    }

    public int killWithId(int id) {
        return id;
    }

    @Stereotype(value=DrugKillingStereotype.class)
    public List<Ricin> killWithRicins(@Optional(defaultValue="#[payload]") List<Ricin> ricins) {
        return ricins;
    }
}

