/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.heisenberg.extension;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.stereotype.Stereotype;
import org.mule.runtime.extension.api.annotation.param.stereotype.Validator;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.test.heisenberg.extension.HeisenbergConnection;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.heisenberg.extension.exception.ValidationErrorTypeProvider;
import org.mule.test.heisenberg.extension.model.PersonalInfo;
import org.mule.test.heisenberg.extension.stereotypes.EmpireStereotype;

@Stereotype(value=EmpireStereotype.class)
public class MoneyLaunderingOperation {
    public static final List<PersonalInfo> INVOLVED_PEOPLE = Arrays.asList(new PersonalInfo("Skyler", 34), new PersonalInfo("BabySkyler", 0), new PersonalInfo("Walter Jr", 17), new PersonalInfo("Walter", 50), new PersonalInfo("Lydia", 33), new PersonalInfo("Mike", 62), new PersonalInfo("Jesse", 21), new PersonalInfo("Saul", 49), new PersonalInfo("Marie", 34), new PersonalInfo("Gus", 45), new PersonalInfo("Tood", 22));
    private long totalLaunderedAmount = 0L;

    public synchronized Long launder(@Config HeisenbergExtension config, long amount) {
        config.setMoney(config.getMoney().subtract(BigDecimal.valueOf(amount)));
        this.totalLaunderedAmount += amount;
        return this.totalLaunderedAmount;
    }

    public PagingProvider<HeisenbergConnection, PersonalInfo> getPagedPersonalInfo() {
        return new PagingProvider<HeisenbergConnection, PersonalInfo>(){
            private int index = 0;

            public List<PersonalInfo> getPage(HeisenbergConnection heisenbergConnection) {
                ArrayList<PersonalInfo> page = new ArrayList<PersonalInfo>();
                for (int i = 0; i < 2 && this.index < INVOLVED_PEOPLE.size(); ++i) {
                    page.add(INVOLVED_PEOPLE.get(this.index++));
                }
                return page;
            }

            public Optional<Integer> getTotalResults(HeisenbergConnection heisenbergConnection) {
                return Optional.of(INVOLVED_PEOPLE.size());
            }

            public void close(HeisenbergConnection connection) throws MuleException {
            }
        };
    }

    public PagingProvider<HeisenbergConnection, String> emptyPagedOperation() {
        return new PagingProvider<HeisenbergConnection, String>(){

            public List<String> getPage(HeisenbergConnection connection) {
                return Collections.emptyList();
            }

            public Optional<Integer> getTotalResults(HeisenbergConnection connection) {
                return Optional.of(0);
            }

            public void close(HeisenbergConnection connection) throws MuleException {
            }
        };
    }

    public PagingProvider<HeisenbergConnection, String> failingPagedOperation() {
        return new PagingProvider<HeisenbergConnection, String>(){

            public List<String> getPage(HeisenbergConnection connection) {
                throw new IllegalArgumentException();
            }

            public Optional<Integer> getTotalResults(HeisenbergConnection connection) {
                return Optional.of(0);
            }

            public void close(HeisenbergConnection connection) throws MuleException {
            }
        };
    }

    public PagingProvider<HeisenbergConnection, String> pagedOperationUsingConnection() {
        return new PagingProvider<HeisenbergConnection, String>(){
            int index = 0;

            public List<String> getPage(HeisenbergConnection connection) {
                if (this.index > 3) {
                    return Collections.emptyList();
                }
                ArrayList<String> numbers = new ArrayList<String>();
                for (int i = 0; i < 3; ++i) {
                    numbers.add(connection.getSaulPhoneNumber());
                }
                ++this.index;
                return numbers;
            }

            public Optional<Integer> getTotalResults(HeisenbergConnection connection) {
                return Optional.of(4);
            }

            public void close(HeisenbergConnection connection) throws MuleException {
                this.index = 0;
            }
        };
    }

    public PagingProvider<HeisenbergConnection, Integer> stickyPagedOperation() {
        return new PagingProvider<HeisenbergConnection, Integer>(){

            public List<Integer> getPage(HeisenbergConnection connection) {
                return Arrays.asList(System.identityHashCode(connection));
            }

            public Optional<Integer> getTotalResults(HeisenbergConnection connection) {
                return Optional.empty();
            }

            public void close(HeisenbergConnection connection) throws MuleException {
            }

            public boolean useStickyConnections() {
                return true;
            }
        };
    }

    public PagingProvider<HeisenbergConnection, Integer> pagedOperationWithExtensionClassLoader() {
        return new PagingProvider<HeisenbergConnection, Integer>(){

            public List<Integer> getPage(HeisenbergConnection heisenbergConnection) {
                if (Thread.currentThread().getContextClassLoader() != this.getClass().getClassLoader()) {
                    throw new RuntimeException("Class Loader was not properly switched by the Paging Provider Wrapper");
                }
                ArrayList<Integer> list = new ArrayList<Integer>();
                list.add(1);
                return list;
            }

            public Optional<Integer> getTotalResults(HeisenbergConnection heisenbergConnection) {
                return Optional.empty();
            }

            public void close(HeisenbergConnection heisenbergConnection) throws MuleException {
                heisenbergConnection.disconnect();
            }
        };
    }

    @Validator
    @Throws(value={ValidationErrorTypeProvider.class})
    public void validateMoney() {
    }
}

