/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.heisenberg.extension;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.sdk.api.annotation.source.BackPressure;
import org.mule.sdk.api.runtime.source.BackPressureMode;
import org.mule.test.heisenberg.extension.model.types.DEAOfficerAttributes;

@Alias(value="dea-radio")
@BackPressure(defaultMode=BackPressureMode.DROP, supportedModes={BackPressureMode.DROP})
public class DEARadioSource
extends Source<List<Result<String, DEAOfficerAttributes>>, Object> {
    public static final int MESSAGES_PER_POLL = 5;
    public static final String MESSAGE_TEXT = "I heard Heisenberg is in the neighborhood";
    @Inject
    private SchedulerService schedulerService;
    @Inject
    private SchedulerConfig baseConfig;
    private Scheduler executor;
    private ScheduledFuture sourceCallbakHandleTask;
    private Random random = new Random();

    public void onStart(SourceCallback<List<Result<String, DEAOfficerAttributes>>, Object> sourceCallback) throws MuleException {
        this.executor = this.schedulerService.cpuLightScheduler(this.baseConfig.withShutdownTimeout(500L, TimeUnit.MILLISECONDS));
        this.sourceCallbakHandleTask = this.executor.scheduleAtFixedRate(() -> sourceCallback.handle(this.makeResult()), 0L, 500L, TimeUnit.MILLISECONDS);
    }

    public void onStop() {
        if (this.sourceCallbakHandleTask != null) {
            this.sourceCallbakHandleTask.cancel(false);
        }
        if (this.executor != null) {
            this.executor.stop();
        }
    }

    private Result<List<Result<String, DEAOfficerAttributes>>, Object> makeResult() {
        ArrayList<Result> messages = new ArrayList<Result>(5);
        for (int i = 0; i < 5; ++i) {
            boolean isHank = this.random.nextInt() % 2 == 0;
            messages.add(Result.builder().output((Object)MESSAGE_TEXT).attributes((Object)new DEAOfficerAttributes(isHank)).build());
        }
        return Result.builder().output(messages).build();
    }
}

