/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.heisenberg.extension;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.ExternalLibraryType;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Export;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.annotation.ExternalLib;
import org.mule.runtime.extension.api.annotation.OnException;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.Sources;
import org.mule.runtime.extension.api.annotation.SubTypeMapping;
import org.mule.runtime.extension.api.annotation.SubTypesMapping;
import org.mule.runtime.extension.api.annotation.connectivity.ConnectionProviders;
import org.mule.runtime.extension.api.annotation.deprecated.Deprecated;
import org.mule.runtime.extension.api.annotation.error.ErrorTypes;
import org.mule.runtime.extension.api.annotation.notification.NotificationActions;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Text;
import org.mule.runtime.extension.api.runtime.source.BackPressureContext;
import org.mule.test.heisenberg.extension.AsyncHeisenbergSource;
import org.mule.test.heisenberg.extension.DEARadioSource;
import org.mule.test.heisenberg.extension.HeisenbergConnectionProvider;
import org.mule.test.heisenberg.extension.HeisenbergErrors;
import org.mule.test.heisenberg.extension.HeisenbergNotificationAction;
import org.mule.test.heisenberg.extension.HeisenbergOperationLifecycleValidator;
import org.mule.test.heisenberg.extension.HeisenbergOperations;
import org.mule.test.heisenberg.extension.HeisenbergRouters;
import org.mule.test.heisenberg.extension.HeisenbergScopes;
import org.mule.test.heisenberg.extension.HeisenbergSource;
import org.mule.test.heisenberg.extension.KillingOperations;
import org.mule.test.heisenberg.extension.MoneyLaunderingOperation;
import org.mule.test.heisenberg.extension.ReconnectableHeisenbergSource;
import org.mule.test.heisenberg.extension.RicinGroup;
import org.mule.test.heisenberg.extension.SecureHeisenbergConnectionProvider;
import org.mule.test.heisenberg.extension.exception.HeisenbergConnectionExceptionEnricher;
import org.mule.test.heisenberg.extension.model.BarberPreferences;
import org.mule.test.heisenberg.extension.model.CarDealer;
import org.mule.test.heisenberg.extension.model.CarWash;
import org.mule.test.heisenberg.extension.model.DifferedKnockableDoor;
import org.mule.test.heisenberg.extension.model.HankSchrader;
import org.mule.test.heisenberg.extension.model.HealthStatus;
import org.mule.test.heisenberg.extension.model.Investment;
import org.mule.test.heisenberg.extension.model.KnockeableDoor;
import org.mule.test.heisenberg.extension.model.PersonalInfo;
import org.mule.test.heisenberg.extension.model.Ricin;
import org.mule.test.heisenberg.extension.model.Weapon;
import org.mule.test.heisenberg.extension.model.drugs.Drug;
import org.mule.test.heisenberg.extension.model.drugs.Meta;

@Extension(name="Heisenberg", category=Category.SELECT)
@Operations(value={HeisenbergOperations.class, MoneyLaunderingOperation.class, KillingOperations.class, HeisenbergScopes.class, HeisenbergRouters.class, HeisenbergOperationLifecycleValidator.class})
@OnException(value=HeisenbergConnectionExceptionEnricher.class)
@ConnectionProviders(value={HeisenbergConnectionProvider.class, SecureHeisenbergConnectionProvider.class})
@Sources(value={HeisenbergSource.class, DEARadioSource.class, AsyncHeisenbergSource.class, ReconnectableHeisenbergSource.class})
@Export(classes={HeisenbergExtension.class, DifferedKnockableDoor.class}, resources={"methRecipe.json"})
@SubTypesMapping(value={@SubTypeMapping(baseType=Weapon.class, subTypes={Ricin.class}), @SubTypeMapping(baseType=Drug.class, subTypes={Meta.class}), @SubTypeMapping(baseType=Investment.class, subTypes={CarWash.class, CarDealer.class})})
@ExternalLib(name="Heisenberg.so", description="Native Heisenberg support", nameRegexpMatcher="heisenberg.so", requiredClassName="org.heisenberg.HeisenbergJNI", type=ExternalLibraryType.NATIVE, coordinates="org.mule.libs:this-is-a-lib:dll:1.0.0")
@Deprecated(message="This extension has been deprecated because Breaking Bad has ended, use Better Call Saul extension.", since="1.4.0")
@ErrorTypes(value=HeisenbergErrors.class)
@NotificationActions(value=HeisenbergNotificationAction.class)
public class HeisenbergExtension
implements Lifecycle {
    public static final String HEISENBERG = "Heisenberg";
    public static final String HEISENBERG_LIB_NAME = "Heisenberg.so";
    public static final String HEISENBERG_LIB_DESCRIPTION = "Native Heisenberg support";
    public static final String HEISENBERG_LIB_FILE_NAME = "heisenberg.so";
    public static final String HEISENBERG_LIB_CLASS_NAME = "org.heisenberg.HeisenbergJNI";
    public static final String AGE = "50";
    public static final String RICIN_GROUP_NAME = "Dangerous-Ricin";
    public static final String RICIN_PACKS_SUMMARY = "A set of ricin packs";
    public static final String PERSONAL_INFORMATION_GROUP_NAME = "Personal Information";
    public static final String INLINE_BARBER_PREFERENCES = "Inline Barber Preferences";
    public static final String BROTHER_IN_LAW = "Brother in law";
    public static final String PARAMETER_OVERRIDED_DISPLAY_NAME = "Parameter Custom Display Name";
    public static final String PARAMETER_ORIGINAL_OVERRIDED_DISPLAY_NAME = "weaponValueMap";
    public static final String LAB_ADDRESS_EXAMPLE = "308 Negra Arroyo Lane, Albuquerque, New Mexico, 87104";
    private int initialise = 0;
    private int start = 0;
    private int stop = 0;
    private int dispose = 0;
    public static volatile int sourceTimesStarted = 0;
    @Inject
    private ExtensionManager extensionManager;
    @Inject
    private ObjectStoreManager objectStoreManager;
    @RefName
    private String configName;
    @Parameter
    @Optional
    private List<PersonalInfo> familyInformations;
    @Parameter
    private List<String> enemies = new LinkedList<String>();
    @Parameter
    private final List<Long> monthlyIncomes = new LinkedList<Long>();
    @Parameter
    private boolean cancer;
    @Parameter
    @Optional
    private Map<String, Long> recipe;
    @Parameter
    @Optional
    private Map<String, List<String>> deathsBySeasons;
    @ParameterGroup(name="Dangerous-Ricin")
    private RicinGroup ricinGroup;
    @ParameterGroup(name="Personal Information")
    @DisplayName(value="Personal Info")
    private final PersonalInfo personalInfo = new PersonalInfo();
    @Parameter
    private BigDecimal money;
    @Parameter
    @Optional
    private final Weapon weapon = new Ricin();
    @Parameter
    @Optional
    private List<? extends Weapon> wildCardWeapons;
    @Parameter
    @Optional
    private List<?> wildCards;
    @Parameter
    @Optional
    @DisplayName(value="Parameter Custom Display Name")
    private Map<String, Weapon> weaponValueMap;
    @Parameter
    @Optional
    private Map<String, KnockeableDoor> candidateDoors;
    @Parameter
    @Optional(defaultValue="CANCER")
    private HealthStatus initialHealth;
    @Parameter
    @Alias(value="finalHealth")
    private HealthStatus endingHealth;
    @Parameter
    @Expression(value=ExpressionSupport.REQUIRED)
    @Optional
    @Example(value="308 Negra Arroyo Lane, Albuquerque, New Mexico, 87104")
    private String labAddress;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Optional
    @Text
    private String firstEndevour;
    @Parameter
    @Optional
    private List<HealthStatus> healthProgressions;
    @ParameterGroup(name="Inline Barber Preferences", showInDsl=true)
    private BarberPreferences barberPreferences;
    @ParameterGroup(name="Brother in law", showInDsl=true)
    @DisplayName(value="Brother in law")
    private HankSchrader brotherInLaw;
    private final List<BackPressureContext> backPressureContexts = new LinkedList<BackPressureContext>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBackPressure(BackPressureContext ctx) {
        List<BackPressureContext> list = this.backPressureContexts;
        synchronized (list) {
            this.backPressureContexts.add(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BackPressureContext> getBackPressureContexts() {
        List<BackPressureContext> list = this.backPressureContexts;
        synchronized (list) {
            return ImmutableList.copyOf(this.backPressureContexts);
        }
    }

    public void initialise() throws InitialisationException {
        ++this.initialise;
    }

    public void start() throws MuleException {
        ++this.start;
    }

    public void stop() throws MuleException {
        ++this.stop;
    }

    public void dispose() {
        ++this.dispose;
    }

    public BarberPreferences getBarberPreferences() {
        return this.barberPreferences;
    }

    public List<HealthStatus> getHealthProgression() {
        return this.healthProgressions;
    }

    public Map<String, Weapon> getWeaponValueMap() {
        return this.weaponValueMap;
    }

    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    public List<String> getEnemies() {
        return this.enemies;
    }

    public void setEnemies(List<String> enemies) {
        this.enemies = enemies;
    }

    public boolean isCancer() {
        return this.cancer;
    }

    public BigDecimal getMoney() {
        return this.money;
    }

    public Map<String, Long> getRecipe() {
        return this.recipe;
    }

    public RicinGroup getRicinGroup() {
        return this.ricinGroup;
    }

    public Map<String, KnockeableDoor> getCandidateDoors() {
        return this.candidateDoors;
    }

    public int getInitialise() {
        return this.initialise;
    }

    public int getStart() {
        return this.start;
    }

    public int getStop() {
        return this.stop;
    }

    public int getDispose() {
        return this.dispose;
    }

    public HealthStatus getInitialHealth() {
        return this.initialHealth;
    }

    public HealthStatus getEndingHealth() {
        return this.endingHealth;
    }

    public PersonalInfo getPersonalInfo() {
        return this.personalInfo;
    }

    void setEndingHealth(HealthStatus endingHealth) {
        this.endingHealth = endingHealth;
    }

    void setMoney(BigDecimal money) {
        this.money = money;
    }

    public String getLabAddress() {
        return this.labAddress;
    }

    public String getFirstEndevour() {
        return this.firstEndevour;
    }

    public Weapon getWeapon() {
        return this.weapon;
    }

    public List<Long> getMonthlyIncomes() {
        return this.monthlyIncomes;
    }

    public Map<String, List<String>> getDeathsBySeasons() {
        return this.deathsBySeasons;
    }

    public String getConfigName() {
        return this.configName;
    }

    public List<? extends Weapon> getWildCardWeapons() {
        return this.wildCardWeapons;
    }

    public ObjectStoreManager getObjectStoreManager() {
        return this.objectStoreManager;
    }
}

