/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.HttpClientFactory;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.HttpServerFactory;

public class ResourceHttpService
implements HttpService {
    public HttpServerFactory getServerFactory() {
        return null;
    }

    public HttpClientFactory getClientFactory() {
        return new HttpClientFactory(){

            public HttpClient create(HttpClientConfiguration configuration) {
                return new HttpClient(){

                    public HttpResponse send(HttpRequest request, int responseTimeout, boolean followRedirects, HttpAuthentication authentication) throws IOException, TimeoutException {
                        String resource = new String(request.getEntity().getBytes());
                        InputStream resourceStream = this.getClass().getClassLoader().getResourceAsStream(resource);
                        String body = null;
                        if (resourceStream != null) {
                            Properties properties = new Properties();
                            try {
                                properties.load(resourceStream);
                            }
                            catch (IOException e) {
                                throw new MuleRuntimeException((Throwable)e);
                            }
                            body = properties.getProperty("Bundle-Description");
                        }
                        return ((HttpResponseBuilder)HttpResponse.builder().entity(ResourceHttpService.this.resolveEntity(body))).build();
                    }

                    public CompletableFuture<HttpResponse> sendAsync(HttpRequest request, int responseTimeout, boolean followRedirects, HttpAuthentication authentication) {
                        return null;
                    }

                    public void start() {
                    }

                    public void stop() {
                    }
                };
            }
        };
    }

    private HttpEntity resolveEntity(String bundleDescription) {
        return bundleDescription == null ? new EmptyHttpEntity() : new ByteArrayHttpEntity(bundleDescription.getBytes());
    }

    public String getName() {
        return "Resource HTTP Service";
    }
}

