/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.test.module.extension.oauth.clientcredentials;

import static com.github.tomakehurst.wiremock.core.WireMockConfiguration.wireMockConfig;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;

public class ClientCredentialsTLSContextConnectivityTestCase extends AbstractClientCredentialsExternalServerTestCase {

  @Override
  protected String[] getConfigFiles() {
    return new String[] {"client-credentials-oauth-tls-context.xml", "client-credentials-flows.xml"};
  }

  @Override
  protected WireMockConfiguration wireMockTestConfig() {
    return wireMockConfig()
        .bindAddress("127.0.0.1")
        .httpsPort(oauthServerPort.getNumber())
        .keystorePath("ssltest-keystore.jks")
        .keystorePassword("changeit")
        .keyManagerPassword("changeit");
  }

  @Override
  protected boolean httpsTest() {
    return true;
  }
}
