/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.test.module.extension.oauth.authcode;

import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.junit.Rule;

public class AuthCodeProxyConfigConnectivityTestCase extends AbstractAuthCodeExternalServerTestCase {

  @Rule
  public DynamicPort oauthServerToProxy = new DynamicPort("oauthServerToProxy");

  protected String authUrl = toUrl(AUTHORIZE_PATH, oauthServerToProxy.getNumber());

  @Rule
  public SystemProperty authorizationUrlToProxy = new SystemProperty("authorizationUrlToProxy", authUrl);

  protected String tokenUrl = toUrl(TOKEN_PATH, oauthServerToProxy.getNumber());

  @Rule
  public SystemProperty accessTokenUrlToProxy = new SystemProperty("accessTokenUrlToProxy", tokenUrl);

  @Override
  protected String[] getConfigFiles() {
    return new String[] {"auth-code-oauth-proxy-config.xml"};
  }


}
