/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.test.module.extension.oauth.authcode;

import static com.github.tomakehurst.wiremock.core.WireMockConfiguration.wireMockConfig;
import static org.mule.runtime.api.connectivity.ConnectivityTestingService.CONNECTIVITY_TESTING_SERVICE_KEY;
import static com.github.tomakehurst.wiremock.client.WireMock.postRequestedFor;
import static com.github.tomakehurst.wiremock.client.WireMock.urlPathEqualTo;
import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.MatcherAssert.assertThat;
import com.github.tomakehurst.wiremock.common.ConsoleNotifier;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.connectivity.ConnectivityTestingService;
import org.mule.test.module.extension.oauth.BaseOAuthExtensionTestCase;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.junit.Before;
import org.junit.Test;

public class AuthCodeTLSContextConnectivityTestCase extends AbstractAuthCodeExternalServerTestCase {

  @Override
  protected String[] getConfigFiles() {
    return new String[] {"auth-code-oauth-tls-context.xml"};
  }

  @Override
  protected WireMockConfiguration wireMockTestConfig() {
    return wireMockConfig()
        .bindAddress("127.0.0.1")
        .httpsPort(oauthServerPort.getNumber())
        .keystorePath("ssltest-keystore.jks")
        .keystorePassword("changeit")
        .keyManagerPassword("changeit");
  }

  @Override
  protected boolean httpsTest() {
    return true;
  }

}
