/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.oauth.authcode;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.exception.ExpectedError;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeState;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.runtime.module.extension.api.util.MuleExtensionUtils;
import org.mule.sdk.api.connectivity.oauth.AuthCodeRequest;
import org.mule.tck.probe.PollingProber;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;
import org.mule.test.module.extension.oauth.BaseOAuthExtensionTestCase;
import org.mule.test.oauth.AuthCodeConfig;
import org.mule.test.oauth.TestOAuthConnection;
import org.mule.test.oauth.TestOAuthConnectionState;

public class OAuthExtensionTestCase
extends BaseOAuthExtensionTestCase {
    @Rule
    public ExpectedError expectedError = ExpectedError.none();

    protected String[] getConfigFiles() {
        return new String[]{"auth-code-oauth-extension-config.xml", "oauth-extension-flows.xml"};
    }

    @Before
    public void setOwnerId() throws Exception {
        this.ownerId = this.getCustomOwnerId();
    }

    @Test
    public void authorizeAndStartDancingBaby() throws Exception {
        this.simulateDanceStart();
        this.verifyAuthUrlRequest();
    }

    @Test
    public void receiveAccessTokenAndUserConnection() throws Exception {
        this.simulateCallback();
        TestOAuthConnectionState connection = ((TestOAuthConnection)((FlowRunner)this.flowRunner("getConnection").withVariable("ownerId", (Object)this.getCustomOwnerId())).run().getMessage().getPayload().getValue()).getState();
        this.assertConnectionState(connection);
        this.assertExternalCallbackUrl((AuthorizationCodeState)connection.getState());
        this.assertOAuthStateStored("_defaultPersistentObjectStore", this.ownerId);
    }

    @Test
    public void refreshToken() throws Exception {
        this.receiveAccessTokenAndUserConnection();
        WireMock.reset();
        this.stubRefreshToken();
        ((FlowRunner)this.flowRunner("refreshToken").withVariable("ownerId", (Object)this.getCustomOwnerId())).run();
        this.wireMock.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/token")));
    }

    @Test
    public void refreshTokenAsync() throws Exception {
        this.receiveAccessTokenAndUserConnection();
        WireMock.reset();
        this.stubRefreshToken();
        ((FlowRunner)this.flowRunner("refreshTokenAsync").withVariable("ownerId", (Object)this.getCustomOwnerId())).run();
        this.wireMock.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/token")));
    }

    @Test
    public void refreshedTokenWasAlreadyExpired() throws Exception {
        this.receiveAccessTokenAndUserConnection();
        this.stubRefreshedTokenAlreadyExpired();
        ((FlowRunner)this.flowRunner("refreshToken").withVariable("ownerId", (Object)this.getCustomOwnerId())).run();
        this.verifyTokenRefreshedTwice();
    }

    @Test
    public void refreshedTokenWasAlreadyExpiredTwice() throws Exception {
        this.receiveAccessTokenAndUserConnection();
        this.stubRefreshedTokenAlreadyExpiredTwice();
        this.expectExpiredTokenException();
        try {
            ((FlowRunner)this.flowRunner("refreshToken").withVariable("ownerId", (Object)this.getCustomOwnerId())).run();
        }
        finally {
            this.verifyTokenRefreshedTwice();
        }
    }

    @Test
    public void refreshTokenForPagedOperationOnFirstPage() throws Exception {
        this.receiveAccessTokenAndUserConnection();
        WireMock.reset();
        this.stubTokenUrl(this.getRefreshTokenResponse());
        ((FlowRunner)this.flowRunner("pagedOperationFailsAtFirstPage").withVariable("ownerId", (Object)this.getCustomOwnerId())).run();
        this.wireMock.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/token")));
    }

    @Test
    public void refreshedTokenAlreadyExpiredForPagedOperationOnFirstPage() throws Exception {
        this.receiveAccessTokenAndUserConnection();
        this.stubRefreshedTokenAlreadyExpired();
        ((FlowRunner)this.flowRunner("pagedOperationFailsAtFirstPage").withVariable("ownerId", (Object)this.getCustomOwnerId())).run();
        this.verifyTokenRefreshedTwice();
    }

    @Test
    public void refreshedTokenAlreadyExpiredTwiceForPagedOperationOnFirstPage() throws Exception {
        this.receiveAccessTokenAndUserConnection();
        this.stubRefreshedTokenAlreadyExpiredTwice();
        this.expectExpiredTokenException();
        try {
            ((FlowRunner)this.flowRunner("pagedOperationFailsAtFirstPage").withVariable("ownerId", (Object)this.getCustomOwnerId())).run();
        }
        finally {
            this.verifyTokenRefreshedTwice();
        }
    }

    @Test
    public void refreshTokenForPagedOperationOnThirdPage() throws Exception {
        this.receiveAccessTokenAndUserConnection();
        WireMock.reset();
        this.stubTokenUrl(this.getRefreshTokenResponse());
        CoreEvent event = ((FlowRunner)this.flowRunner("pagedOperationFailsAtThirdPage").withVariable("ownerId", (Object)this.getCustomOwnerId())).run();
        this.wireMock.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/token")));
        List accumulator = (List)((TypedValue)event.getVariables().get("accumulator")).getValue();
        Assert.assertThat((Object)accumulator, (Matcher)Matchers.hasSize((int)3));
        Assert.assertThat((Object)accumulator, (Matcher)Matchers.contains((Object[])new String[]{"item 1", "item 2", "item 3"}));
    }

    @Test
    public void refreshedTokenAlreadyExpiredForPagedOperationOnThirdPage() throws Exception {
        this.receiveAccessTokenAndUserConnection();
        this.stubRefreshedTokenAlreadyExpired();
        CoreEvent event = ((FlowRunner)this.flowRunner("pagedOperationFailsAtThirdPage").withVariable("ownerId", (Object)this.getCustomOwnerId())).run();
        this.verifyTokenRefreshedTwice();
        List accumulator = (List)((TypedValue)event.getVariables().get("accumulator")).getValue();
        Assert.assertThat((Object)accumulator, (Matcher)Matchers.hasSize((int)3));
        Assert.assertThat((Object)accumulator, (Matcher)Matchers.contains((Object[])new String[]{"item 1", "item 2", "item 3"}));
    }

    @Test
    public void refreshedTokenAlreadyExpiredTwiceForPagedOperationOnThirdPage() throws Exception {
        this.receiveAccessTokenAndUserConnection();
        this.stubRefreshedTokenAlreadyExpiredTwice();
        this.expectExpiredTokenException();
        try {
            ((FlowRunner)this.flowRunner("pagedOperationFailsAtThirdPage").withVariable("ownerId", (Object)this.getCustomOwnerId())).run();
        }
        finally {
            this.verifyTokenRefreshedTwice();
        }
    }

    @Test
    public void callbackFlows() throws Exception {
        this.authorizeAndStartDancingBaby();
        this.receiveAccessTokenAndUserConnection();
        CoreEvent initialiserEvent = null;
        try {
            initialiserEvent = MuleExtensionUtils.getInitialiserEvent((MuleContext)muleContext);
            AuthCodeConfig config = (AuthCodeConfig)ExtensionsTestUtils.getConfigurationFromRegistry((String)"oauth", (CoreEvent)CoreEvent.builder((CoreEvent)initialiserEvent).addVariable("ownerId", (Object)this.getCustomOwnerId()).build(), (MuleContext)muleContext);
            PollingProber.check((long)10000L, (long)500L, () -> {
                Assert.assertThat((Object)config.getCapturedAuthCodeRequests(), (Matcher)Matchers.hasSize((int)1));
                Assert.assertThat((Object)config.getCapturedAuthCodeStates(), (Matcher)Matchers.hasSize((int)1));
                return true;
            });
            this.assertBeforeCallbackPayload(config);
            this.assertAfterCallbackPayload(config);
        }
        finally {
            if (initialiserEvent != null) {
                ((BaseEventContext)initialiserEvent.getContext()).success();
            }
        }
    }

    @Test
    public void unauthorize() throws Exception {
        this.authorizeAndStartDancingBaby();
        this.receiveAccessTokenAndUserConnection();
        ((FlowRunner)this.flowRunner("unauthorize").withVariable("ownerId", (Object)this.ownerId)).run();
        ObjectStore objectStore = this.getObjectStore("_defaultPersistentObjectStore");
        Assert.assertThat((Object)objectStore.retrieveAll().size(), (Matcher)CoreMatchers.is((Object)0));
        if (this.expectedError != null) {
            this.expectedError.expectErrorType("TEST-OAUTH", MuleErrors.CONNECTIVITY.name());
        }
        ((FlowRunner)this.flowRunner("refreshToken").withVariable("ownerId", (Object)this.getCustomOwnerId())).run();
    }

    @Test
    public void reauthorize() throws Exception {
        this.expectedError = null;
        try {
            this.unauthorize();
        }
        catch (Exception e) {
            Assert.assertThat((Object)e.getCause().getClass().getName(), (Matcher)Matchers.containsString((String)"TokenInvalidatedException"));
        }
        this.authorizeAndStartDancingBaby();
        this.receiveAccessTokenAndUserConnection();
    }

    protected void assertBeforeCallbackPayload(AuthCodeConfig config) {
        AuthCodeRequest request = (AuthCodeRequest)config.getCapturedAuthCodeRequests().get(0);
        Assert.assertThat((Object)request.getResourceOwnerId(), (Matcher)CoreMatchers.is((Object)this.ownerId));
        this.assertScopes(request);
        Assert.assertThat((Object)((String)request.getState().get()), (Matcher)CoreMatchers.is((Object)"myState"));
        this.assertExternalCallbackUrl(request);
    }

    protected void assertScopes(AuthCodeRequest request) {
        Assert.assertThat((Object)((String)request.getScopes().get()), (Matcher)CoreMatchers.is((Object)"this, that, those"));
    }

    private void assertAfterCallbackPayload(AuthCodeConfig config) {
        AuthorizationCodeState state = (AuthorizationCodeState)config.getCapturedAuthCodeStates().get(0);
        Assert.assertThat((Object)state.getAccessToken(), (Matcher)CoreMatchers.is((Object)"rbBQLgJXBEYo83K4Fqs4gu6vpCobc2ya"));
        Assert.assertThat((Object)((String)state.getRefreshToken().get()), (Matcher)CoreMatchers.is((Object)"cry825cyCs2O0j7tRXXVS4AXNu7hsO5wbWjcBoFFcJePy5zZwuQEevIp6hsUaywp"));
        Assert.assertThat((Object)state.getResourceOwnerId(), (Matcher)CoreMatchers.is((Object)this.ownerId));
        Assert.assertThat((Object)((String)state.getExpiresIn().get()), (Matcher)CoreMatchers.is((Object)"3897"));
        Assert.assertThat((Object)((String)state.getState().get()), (Matcher)CoreMatchers.is((Object)"myState"));
        Assert.assertThat((Object)state.getAuthorizationUrl(), (Matcher)CoreMatchers.is((Object)this.authUrl));
        Assert.assertThat((Object)state.getAccessTokenUrl(), (Matcher)CoreMatchers.is((Object)this.tokenUrl));
        Assert.assertThat((Object)state.getConsumerKey(), (Matcher)CoreMatchers.is((Object)"ndli93xdws2qoe6ms1d389vl6bxquv3e"));
        Assert.assertThat((Object)state.getConsumerSecret(), (Matcher)CoreMatchers.is((Object)"yL692Az1cNhfk1VhTzyx4jOjjMKBrO9T"));
        this.assertExternalCallbackUrlOnAfterCallback(state);
    }

    protected void assertExternalCallbackUrl(AuthCodeRequest request) {
        Assert.assertThat((Object)request.getExternalCallbackUrl().isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    protected void assertExternalCallbackUrlOnAfterCallback(AuthorizationCodeState state) {
        Assert.assertThat((Object)state.getExternalCallbackUrl().isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    protected void assertExternalCallbackUrl(AuthorizationCodeState state) {
        Assert.assertThat((Object)state.getExternalCallbackUrl().isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }
}

