/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.oauth.authcode;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.sdk.api.connectivity.oauth.AuthCodeRequest;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.module.extension.oauth.authcode.OAuthExtensionTestCase;

public class ScopelessOAuthExtensionTestCase
extends OAuthExtensionTestCase {
    @Rule
    public DynamicPort otherCallbackPort = new DynamicPort("otherCallbackPort");

    @Override
    protected String[] getConfigFiles() {
        return new String[]{"scopeless-oauth-extension-config.xml", "oauth-extension-flows.xml"};
    }

    @Override
    protected void assertScopes(AuthCodeRequest request) {
        Assert.assertThat((Object)request.getScopes().isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Override
    @Before
    public void setOwnerId() {
        this.ownerId = this.getCustomOwnerId();
    }

    @Override
    protected void verifyAuthUrlRequest() {
        this.wireMock.verify(WireMock.getRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/authorize")).withQueryParam("redirect_uri", WireMock.equalTo((String)this.toUrl("callback", this.callbackPort.getNumber()))).withQueryParam("client_id", WireMock.equalTo((String)"ndli93xdws2qoe6ms1d389vl6bxquv3e")).withQueryParam("state", WireMock.containing((String)"myState")));
    }

    @Test
    public void testDefaultScopesOnDifferentConnectionProvidersAreHonored() throws Exception {
        this.simulateDanceStart(this.callbackPort.getNumber());
        this.verifyAuthUrlRequest(this.callbackPort.getNumber(), null);
        this.simulateDanceStart(this.otherCallbackPort.getNumber());
        this.verifyAuthUrlRequest(this.otherCallbackPort.getNumber(), "defaultScope");
    }
}

