/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.oauth.authcode;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.connectivity.ConnectivityTestingService;
import org.mule.test.module.extension.oauth.BaseOAuthExtensionTestCase;

public abstract class AbstractAuthCodeExternalServerTestCase
extends BaseOAuthExtensionTestCase {
    @Inject
    @Named(value="_muleConnectivityTestingService")
    protected ConnectivityTestingService connectivityTestingService;

    public boolean addToolingObjectsToRegistry() {
        return true;
    }

    @Before
    public void setOwnerId() throws Exception {
        this.ownerId = this.getCustomOwnerId();
    }

    @Test
    public void expiredToken() throws Exception {
        ConnectionValidationResult connectionValidationResult = this.testConnection();
        MatcherAssert.assertThat((Object)connectionValidationResult.isValid(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void refreshTokenOnConnectionValidation() throws Exception {
        this.simulateCallback();
        this.wireMock.resetAll();
        this.stubRefreshToken();
        ConnectionValidationResult connectionValidationResult = this.testConnection();
        MatcherAssert.assertThat((Object)connectionValidationResult.isValid(), (Matcher)CoreMatchers.is((Object)true));
        this.wireMock.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/token")));
    }

    @Test
    public void refreshedTokenAlreadyExpiredOnConnectionValidation() throws Exception {
        this.simulateCallback();
        this.stubRefreshedTokenAlreadyExpiredOnce();
        ConnectionValidationResult connectionValidationResult = this.testConnection();
        this.verifyTokenRefreshedTwice();
        MatcherAssert.assertThat((Object)connectionValidationResult.isValid(), (Matcher)CoreMatchers.is((Object)true));
    }

    private ConnectionValidationResult testConnection() {
        return this.connectivityTestingService.testConnection(Location.builder().globalName("oauth").build());
    }
}

