/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.oauth.authcode;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.module.extension.oauth.BaseOAuthExtensionTestCase;

public class OAuthExtensionWithIncludeRedirectUriInRefreshTokenTestCase
extends BaseOAuthExtensionTestCase {
    @Rule
    public DynamicPort otherCallbackPort = new DynamicPort("otherCallbackPort");

    protected String[] getConfigFiles() {
        return new String[]{"auth-code-oauth-extension-with-include-redirect-uri-in-refresh-token-config.xml", "oauth-extension-flows.xml"};
    }

    @Before
    public void setOwnerId() {
        this.ownerId = this.getCustomOwnerId();
    }

    @Test
    public void testRedirectUriParamIsIncludedForTokenRequest() {
        this.simulateCallback(this.callbackPort.getNumber());
        this.wireMock.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/token")).withRequestBody((ContentPattern)WireMock.containing((String)"redirect_uri")));
    }

    @Test
    public void testRedirectUriParamIsNotIncludedForRefreshTokenRequest() throws Exception {
        this.simulateCallback(this.callbackPort.getNumber());
        WireMock.reset();
        this.stubRefreshToken();
        ((FlowRunner)this.flowRunner("refreshToken").withVariable("ownerId", (Object)this.getCustomOwnerId())).run();
        this.wireMock.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/token")).withRequestBody((ContentPattern)WireMock.notMatching((String)".*redirect_uri.*")));
    }

    @Test
    public void testRedirectUriParamIsIncludedByDefaultForRefreshTokenRequest() throws Exception {
        this.simulateCallback(this.otherCallbackPort.getNumber());
        WireMock.reset();
        this.stubRefreshToken();
        ((FlowRunner)this.flowRunner("refreshOtherToken").withVariable("ownerId", (Object)this.getCustomOwnerId())).run();
        this.wireMock.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/token")).withRequestBody((ContentPattern)WireMock.containing((String)"redirect_uri")));
    }
}

