/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.oauth.clientcredentials;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import io.qameta.allure.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.module.extension.oauth.BaseOAuthExtensionTestCase;
import org.mule.test.oauth.ClientCredentialsConfig;
import org.mule.test.oauth.TestOAuthConnection;
import org.mule.test.oauth.TestOAuthConnectionState;

public class DynamicOAuthClientCredentialsExtensionTestCase
extends BaseOAuthExtensionTestCase {
    private static final String CLIENT_ID = "dynamicClientId";
    private static final String CLIENT_SECRET = "dynamicClientSecret";
    private static final String SCOPES = "dynamic scopes list";
    private static final String ANOTHER_CLIENT_ID = "anotherDynamicClientId";
    private static final String ANOTHER_CLIENT_SECRET = "anotherDynamicClientSecret";
    private static final String ANOTHER_SCOPES = "another scope set";
    private static final String CLIENT_ID_VARIABLE = "clientId";
    private static final String CLIENT_SECRET_VARIABLE = "clientSecret";
    private static final String TOKEN_URL_VARIABLE = "tokenUrl";
    private static final String SCOPES_VARIABLE = "scopes";
    private static final String DYNAMIC_PARAMETER_NAME = "apiVersion";
    private static final Integer POLLING_TIMEOUT = 10000;
    private static final Integer POLLING_INTERVAL = 1000;

    protected String[] getConfigFiles() {
        return new String[]{"dynamic-client-credentials-oauth-extension-config.xml", "client-credentials-flows.xml"};
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.wireMock.stubFor(WireMock.post((UrlPattern)WireMock.urlPathMatching((String)"/token")).willReturn(WireMock.aResponse().withStatus(HttpConstants.HttpStatus.OK.getStatusCode()).withBody(this.accessTokenContent()).withHeader("Content-Type", new String[]{"application/json"})));
    }

    @Test
    @Description(value="Use different values for client credentials paramenter and check that those values are used.")
    public void getConnectionWithDynamicConfig() throws Exception {
        this.getConnectionFlow(CLIENT_ID, CLIENT_SECRET, SCOPES);
        this.verifyCall(CLIENT_ID, CLIENT_SECRET, SCOPES);
    }

    @Test
    @Description(value="Create two dynamic configuration with different values and check the second values are used for the dance.")
    public void getSecondConnectionwithDynamicConfig() throws Exception {
        this.getConnectionFlow(CLIENT_ID, CLIENT_SECRET, SCOPES);
        this.getConnectionFlow(ANOTHER_CLIENT_ID, ANOTHER_CLIENT_SECRET, ANOTHER_SCOPES);
        this.verifyCall(ANOTHER_CLIENT_ID, ANOTHER_CLIENT_SECRET, ANOTHER_SCOPES);
    }

    @Test
    @Description(value="Create two different configurations with the same oauth config and check their access tokens do not overwrite each other.")
    public void differentConfigsWithSameOAuthConfigUseDifferentTokens() throws Exception {
        CoreEvent firstEvent = this.runFlow("getConnection", CLIENT_ID, CLIENT_SECRET, SCOPES, "34.0");
        TestOAuthConnectionState firstConnectionState = ((TestOAuthConnection)firstEvent.getMessage().getPayload().getValue()).getState();
        ClientCredentialsConfig config = (ClientCredentialsConfig)muleContext.getExtensionManager().getConfiguration("oauth", firstEvent).getValue();
        WireMock.reset();
        this.wireMock.stubFor(WireMock.post((UrlPattern)WireMock.urlPathMatching((String)"/token")).willReturn(WireMock.aResponse().withStatus(HttpConstants.HttpStatus.OK.getStatusCode()).withBody(this.accessTokenContent("cry825cyCs2O0j7tRXXVS4AXNu7hsO5wbWjcBoFFcJePy5zZwuQEevIp6hsUaywp")).withHeader("Content-Type", new String[]{"application/json"})));
        TestOAuthConnectionState secondConnectionState = ((TestOAuthConnection)this.runFlow("getAnotherConnection", CLIENT_ID, CLIENT_SECRET, SCOPES, "34.0").getMessage().getPayload().getValue()).getState();
        new PollingProber((long)POLLING_TIMEOUT.intValue(), (long)POLLING_INTERVAL.intValue()).check((Probe)new JUnitLambdaProbe(() -> {
            Assert.assertThat((Object)config.getDispose(), (Matcher)Matchers.is((Object)1));
            return true;
        }, "config was not disposed"));
        TestOAuthConnectionState thirdConnectionState = ((TestOAuthConnection)this.runFlow("getConnection", CLIENT_ID, CLIENT_SECRET, SCOPES, "34.0").getMessage().getPayload().getValue()).getState();
        Assert.assertThat((Object)firstConnectionState.getState().getAccessToken(), (Matcher)Matchers.is((Object)thirdConnectionState.getState().getAccessToken()));
        Assert.assertThat((Object)firstConnectionState.getState().getAccessToken(), (Matcher)Matchers.not((Object)secondConnectionState.getState().getAccessToken()));
    }

    @Test
    @Description(value="Create two instances of a dynamic configuration with different oauth configs and check their access tokens do not overwrite each other.")
    public void dynamicConfigsWithDifferentCredentialsUseDifferentTokens() throws Exception {
        CoreEvent firstEvent = this.getConnectionFlow(CLIENT_ID, CLIENT_SECRET, SCOPES);
        TestOAuthConnectionState firstConnectionState = ((TestOAuthConnection)firstEvent.getMessage().getPayload().getValue()).getState();
        ClientCredentialsConfig config = (ClientCredentialsConfig)muleContext.getExtensionManager().getConfiguration("oauth", firstEvent).getValue();
        WireMock.reset();
        this.wireMock.stubFor(WireMock.post((UrlPattern)WireMock.urlPathMatching((String)"/token")).willReturn(WireMock.aResponse().withStatus(HttpConstants.HttpStatus.OK.getStatusCode()).withBody(this.accessTokenContent("cry825cyCs2O0j7tRXXVS4AXNu7hsO5wbWjcBoFFcJePy5zZwuQEevIp6hsUaywp")).withHeader("Content-Type", new String[]{"application/json"})));
        TestOAuthConnectionState secondConnectionState = ((TestOAuthConnection)this.getConnectionFlow(ANOTHER_CLIENT_ID, ANOTHER_CLIENT_SECRET, ANOTHER_SCOPES).getMessage().getPayload().getValue()).getState();
        new PollingProber((long)POLLING_TIMEOUT.intValue(), (long)POLLING_INTERVAL.intValue()).check((Probe)new JUnitLambdaProbe(() -> {
            Assert.assertThat((Object)config.getDispose(), (Matcher)Matchers.is((Object)1));
            return true;
        }, "config was not disposed"));
        TestOAuthConnectionState thirdConnectionState = ((TestOAuthConnection)this.getConnectionFlow(CLIENT_ID, CLIENT_SECRET, SCOPES).getMessage().getPayload().getValue()).getState();
        Assert.assertThat((Object)firstConnectionState.getState().getAccessToken(), (Matcher)Matchers.is((Object)thirdConnectionState.getState().getAccessToken()));
        Assert.assertThat((Object)firstConnectionState.getState().getAccessToken(), (Matcher)Matchers.not((Object)secondConnectionState.getState().getAccessToken()));
    }

    @Test
    @Description(value="Create two instances of a dynamic configuration with different config parameters but the same oauth config and check they use the same token")
    public void dynamicConfigsWithSameOAuthConfigUseSameToken() throws Exception {
        CoreEvent firstEvent = this.getConnectionFlow(CLIENT_ID, CLIENT_SECRET, SCOPES, "34.0");
        TestOAuthConnectionState firstConnectionState = ((TestOAuthConnection)firstEvent.getMessage().getPayload().getValue()).getState();
        ClientCredentialsConfig config = (ClientCredentialsConfig)muleContext.getExtensionManager().getConfiguration("oauth", firstEvent).getValue();
        WireMock.reset();
        this.wireMock.stubFor(WireMock.post((UrlPattern)WireMock.urlPathMatching((String)"/token")).willReturn(WireMock.aResponse().withStatus(HttpConstants.HttpStatus.OK.getStatusCode()).withBody(this.accessTokenContent("cry825cyCs2O0j7tRXXVS4AXNu7hsO5wbWjcBoFFcJePy5zZwuQEevIp6hsUaywp")).withHeader("Content-Type", new String[]{"application/json"})));
        TestOAuthConnectionState secondConnectionState = ((TestOAuthConnection)this.getConnectionFlow(CLIENT_ID, CLIENT_SECRET, SCOPES, "34.1").getMessage().getPayload().getValue()).getState();
        new PollingProber((long)POLLING_TIMEOUT.intValue(), (long)POLLING_INTERVAL.intValue()).check((Probe)new JUnitLambdaProbe(() -> {
            Assert.assertThat((Object)config.getDispose(), (Matcher)Matchers.is((Object)1));
            return true;
        }, "config was not disposed"));
        TestOAuthConnectionState thirdConnectionState = ((TestOAuthConnection)this.getConnectionFlow(CLIENT_ID, CLIENT_SECRET, SCOPES, "34.0").getMessage().getPayload().getValue()).getState();
        Assert.assertThat((Object)firstConnectionState.getState().getAccessToken(), (Matcher)Matchers.is((Object)thirdConnectionState.getState().getAccessToken()));
        Assert.assertThat((Object)firstConnectionState.getState().getAccessToken(), (Matcher)Matchers.is((Object)secondConnectionState.getState().getAccessToken()));
    }

    private CoreEvent getConnectionFlow(String clientId, String clientSecret, String scopes) throws Exception {
        return this.getConnectionFlow(clientId, clientSecret, scopes, "34.0");
    }

    private CoreEvent getConnectionFlow(String clientId, String clientSecret, String scopes, String dynamicParameterValue) throws Exception {
        return this.runFlow("getConnection", clientId, clientSecret, scopes, dynamicParameterValue);
    }

    private CoreEvent runFlow(String flowName, String clientId, String clientSecret, String scopes, String dynamicParameterValue) throws Exception {
        return ((FlowRunner)((FlowRunner)((FlowRunner)((FlowRunner)((FlowRunner)this.flowRunner(flowName).withVariable(TOKEN_URL_VARIABLE, (Object)this.tokenUrl)).withVariable(CLIENT_ID_VARIABLE, (Object)clientId)).withVariable(CLIENT_SECRET_VARIABLE, (Object)clientSecret)).withVariable(SCOPES_VARIABLE, (Object)scopes)).withVariable(DYNAMIC_PARAMETER_NAME, (Object)dynamicParameterValue)).run();
    }

    private void verifyCall(String clientId, String clientSecret, String scopes) {
        this.wireMock.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/token")).withQueryParam("client_id", WireMock.equalTo((String)clientId)).withQueryParam("client_secret", WireMock.equalTo((String)clientSecret)).withRequestBody((ContentPattern)WireMock.containing((String)scopes.replaceAll(" ", "\\+"))));
    }
}

